from setuptools import setup

with open("README.md") as f:
    long_description = f.read()

setup(
    name='zoommotion',
    version='1.0.0',
    description="Automatically zoom in on video content of interest",
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://git.rcrnstn.net/rcrnstn/zoommotion',
    author="Robert Cranston",
    keywords='ffmpeg opencv',
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: ISC License (ISCL)',
    ],
    python_requires='>=3, <4',
    install_requires=[
        'pyffstream @ git+https://git.rcrnstn.net/rcrnstn/pyffstream',
        'numpy',
        'Pillow',
        'opencv-python',
        'scipy',
    ],
    py_modules=['zoommotion'],
    entry_points={
        'console_scripts': [
            'zoommotion = zoommotion:main',
        ],
    },
)
