# [`zoommotion`][]

Zoom in on video motion.

[`zoommotion`]: https://git.rcrnstn.net/rcrnstn/zoommotion

## Install

Make sure [Python is installed][Python download], [`pip`][] is available and
the [`pip`][], [`setuptools`][] and [`wheel`][] packages are up to date:

```sh
python3 -m pip install --user --upgrade pip setuptools wheel
```

Reference: [Python Packaging User Guide: Requirements for Installing
Packages][].

[Python download]: https://python.org/download
[`pip`]: https://pip.readthedocs.io
[`setuptools`]: https://setuptools.readthedocs.io
[`wheel`]: https://wheel.readthedocs.io
[Python Packaging User Guide: Requirements for Installing Packages]: https://packaging.python.org/tutorials/installing-packages/#requirements-for-installing-packages

### With [`pipx`][], for users

Make sure [`pipx`][] is installed:

```sh
python3 -m pip install --user pipx
```

Install `zoommotion`:

```sh
pipx install "git+https://git.rcrnstn.net/rcrnstn/zoommotion"
```

`zoommotion` should now be in your [`PATH`][] (if not, run `python3 -m pipx
ensurepath`).

Reference: [Python Packaging User Guide: Installing stand alone command line
tools][].

[`pipx`]: https://pipxproject.github.io/pipx/
[`PATH`]: https://en.wikipedia.org/wiki/PATH_(variable)
[Python Packaging User Guide: Installing stand alone command line tools]: https://packaging.python.org/guides/installing-stand-alone-command-line-tools/

### Into [`venv`][], for developers

Clone and install into a repository [`venv`][] virtual environment:

```sh
git clone "https://git.rcrnstn.net/rcrnstn/zoommotion"
cd "zoommotion"
python3 -m venv .venv
. .venv/bin/activate
python3 -m pip install --editable .
```

`zoommotion` should now be in your (virtual environment) [`PATH`][].

Reference: [Python Packaging User Guide: Installing packages using pip and
virtual environments][].

[`venv`]: https://docs.python.org/3/library/venv.html
[Python Packaging User Guide: Installing packages using pip and virtual environments]: https://packaging.python.org/guides/installing-using-pip-and-virtual-environments/

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC license]: https://en.wikipedia.org/wiki/ISC_license
[`LICENSE`]: LICENSE
