# [`zoommotion`][]

Zoom in on video motion.

-   [Usage](#usage)
-   [Install](#install)
    -   [With `pipx`, for users](#with-pipx-for-users)
    -   [Into `venv`, for developers](#into-venv-for-developers)
-   [License](#license)

`zoommotion` is implemented in [Python][], uses [OpenCV][] and [SciPy][] for
processing, and external [FFmpeg][] processes for broad file read and write
support (via [`ffmpeg-python`][] and [`pyffstream`][]).

Simple algorithms are used to achieve speed with acceptable results ([Gaussian
mixture background/foreground segmentation][] and [Gaussian blur][] paired with
a [Butterworth filter][]). Algorithm parameters and input/output file
parameters can be supplied with command line options, see [Usage](#usage).

[`zoommotion`]: https://git.rcrnstn.net/rcrnstn/zoommotion
[Python]: https://www.python.org
[OpenCV]: https://opencv.org/about/
[SciPy]: https://www.scipy.org
[FFmpeg]: https://ffmpeg.org
[`ffmpeg-python`]: https://github.com/kkroening/ffmpeg-python
[`pyffstream`]: https://git.rcrnstn.net/rcrnstn/pyffstream
[Gaussian mixture background/foreground segmentation]: https://docs.opencv.org/3.4/d7/d7b/classcv_1_1BackgroundSubtractorMOG2.html
[Gaussian blur]: https://docs.opencv.org/3.4/d4/d86/group__imgproc__filter.html#gaabe8c836e97159a9193fb0b11ac52cf1
[Butterworth filter]: https://docs.scipy.org/doc/scipy/reference/generated/scipy.signal.butter.html

## Usage

`zoommotion --help`:

```
usage: zoommotion [-h] [--margins L R T B] [--blur-factor F]
                  [--blur-threshold T] [--lowpass-factor F]
                  [--start-frame FRAME] [--end-frame FRAME] [--decimate COUNT]
                  [--width WIDTH] [--height HEIGHT] [--codec CODEC]
                  [--pix-fmt PIX_FMT] [--extra-args ARGS] [--no-preview]
                  [--no-write] [--no-audio] [--overwrite] [--debug DEBUG_FILE]
                  [--output OUTPUT_FILE]
                  INPUT_FILE

Zoom in on video motion.

positional arguments:
  INPUT_FILE            input file

optional arguments:
  -h, --help            show this help message and exit
  --margins L R T B     margins (left, right, top, bottom, in percent) of
                        output video (default: [0, 0, 0, 0])
  --blur-factor F       blur size factor (default: 0.05)
  --blur-threshold T    blur threshold (default: 32)
  --lowpass-factor F    low-pass filter cutoff frequency factor (default:
                        0.00015)
  --start-frame FRAME   starting input frame to process (inclusive)
  --end-frame FRAME     ending input frame to process (exclusive)
  --decimate COUNT      only use every COUNT input frame
  --width WIDTH         width of output video
  --height HEIGHT       height of output video
  --codec CODEC         codec of output video
  --pix-fmt PIX_FMT     pixel format of output video
  --extra-args ARGS     extra arguments to pass to FFmpeg, as a JSON object
                        (do not specify the leading dash for keys, use a null
                        value for arguments that do not take a parameter)
  --no-preview          do not show any previews
  --no-write            do not write any files
  --no-audio            do not include audio in output files
  --overwrite           overwrite output files
  --debug DEBUG_FILE    produce debug output (leave empty to base filename on
                        input)
  --output OUTPUT_FILE  produce final output (leave empty to base filename on
                        input)
```

## Install

Make sure [Python is installed][Python download], [`pip`][] is available and
the [`pip`][], [`setuptools`][] and [`wheel`][] packages are up to date:

```sh
python3 -m pip install --user --upgrade pip setuptools wheel
```

Reference: [Python Packaging User Guide: Requirements for Installing
Packages][].

[Python download]: https://python.org/download
[`pip`]: https://pip.readthedocs.io
[`setuptools`]: https://setuptools.readthedocs.io
[`wheel`]: https://wheel.readthedocs.io
[Python Packaging User Guide: Requirements for Installing Packages]: https://packaging.python.org/tutorials/installing-packages/#requirements-for-installing-packages

### With [`pipx`][], for users

Make sure [`pipx`][] is installed:

```sh
python3 -m pip install --user pipx
```

Install `zoommotion`:

```sh
pipx install "git+https://git.rcrnstn.net/rcrnstn/zoommotion"
```

`zoommotion` should now be in your [`PATH`][] (if not, run `python3 -m pipx
ensurepath`).

Reference: [Python Packaging User Guide: Installing stand alone command line
tools][].

[`pipx`]: https://pipxproject.github.io/pipx/
[`PATH`]: https://en.wikipedia.org/wiki/PATH_(variable)
[Python Packaging User Guide: Installing stand alone command line tools]: https://packaging.python.org/guides/installing-stand-alone-command-line-tools/

### Into [`venv`][], for developers

Clone and install into a repository [`venv`][] virtual environment:

```sh
git clone "https://git.rcrnstn.net/rcrnstn/zoommotion"
cd "zoommotion"
python3 -m venv .venv
. .venv/bin/activate
python3 -m pip install --editable .
```

`zoommotion` should now be in your (virtual environment) [`PATH`][].

Reference: [Python Packaging User Guide: Installing packages using pip and
virtual environments][].

[`venv`]: https://docs.python.org/3/library/venv.html
[Python Packaging User Guide: Installing packages using pip and virtual environments]: https://packaging.python.org/guides/installing-using-pip-and-virtual-environments/

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC license]: https://en.wikipedia.org/wiki/ISC_license
[`LICENSE`]: LICENSE
