#!/usr/bin/env python3

import sys
import http.server
import ssl


PORT   = 8000
HOST   = ""
PUBLIC = "public"


class Handler(http.server.SimpleHTTPRequestHandler):

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs, directory=PUBLIC)


args = iter(sys.argv[1:])
port = int(next(args, PORT))
host = str(next(args, HOST))

context = ssl.SSLContext(ssl.PROTOCOL_TLS_SERVER)
context.load_cert_chain("cert.pem", "key.pem")

httpd = http.server.HTTPServer((host, port), Handler)
httpd.socket = context.wrap_socket(httpd.socket, server_side=True)

httpd.serve_forever()
