"use strict";

const type    = "image/jpeg";
const quality = 0.95;
const width   = 1920;
const height  = 1440;
const timeout = 250;

const camera  = document.getElementById("camera");
const message = document.createElement("div");
const video   = document.createElement("video");
const canvas  = document.createElement("canvas")
const ctx     = canvas.getContext("2d");

let facingMode = "environment";
let timer      = null;

async function getVideo() {
    try {
        video.srcObject = await navigator.mediaDevices.getUserMedia({
            video: { facingMode, width, height },
        });
        video.play();
    } catch (err) {
        camera.removeChild(video);
        message.innerHTML = `Could not get video: ${err.name}: ${err.message}`;
    }
}

async function post()
{
    try {
        message.innerHTML = "Posting...";
        canvas.width  = video.videoWidth;
        canvas.height = video.videoHeight;
        ctx.drawImage(video, 0, 0);
        const blob = await new Promise((r) => canvas.toBlob(r, type, quality));
        const resp = await fetch("/", {
            method: "POST",
            body:   blob,
        });
        message.innerHTML = `${resp.status}: ${resp.statusText}`;
    } catch (err) {
        message.innerHTML = `${err.name}: ${err.message}`;
    }
}

function flip() {
    facingMode = facingMode == "environment" ? "user" : "environment";
    getVideo();
}

function timerSelector(first, second, initiate) {
    return () => {
        if (timer == null) {
            if (initiate)
                timer = setTimeout(() => { timer = null; first(); }, timeout);
        } else {
            clearTimeout(timer);
            timer = null;
            second();
        }
    }
}

message.innerHTML = "Press video to post, double press to flip.";
video.addEventListener("click", timerSelector(post, flip, true));
camera.appendChild(message);
camera.appendChild(video);
getVideo();
