""
" @section About
" - Version: 1.0.0
" - Author:  Robert Cranston
" - License: ISC
" - URL:     https://git.rcrnstn.net/rcrnstn/vim-unobtrusive-fold
" @order intro config commands functions example about

""
" @section Introduction, intro
" unobtrusive-fold provides commands that define folds from text that blends in
" with the rest of the content, such as comments or markup headings.
" Optionally, this can be combined with folds for indented paragraphs. Folds
" are automatically ended when the indentation drops below that of the line
" where the fold was introduced. It also provides 'foldtext' function and a
" command for debugging 'foldexpr's.

""
" @section Example
" Example |vimrc|:
" >
"   set commentstring=
"   set shiftwidth=2
"   set textwidth=79
"   set fillchars+=fold:─
"   set foldtext=unobtrusive_fold#text()
"
"   syntax enable
"   filetype plugin indent on
"
"   autocmd FileType *        UnobtrusiveFoldComment
"   autocmd FileType markdown UnobtrusiveFoldChar #

"" Guard
if exists('g:loaded_unobtrusive_fold') || &compatible
  finish
endif
let g:loaded_unobtrusive_fold = 1

"" Commands

"" :UnobtrusiveFoldComment

""
" Sets the current window's 'foldmethod', 'foldexpr', and plugin-internal
" variables based on the current buffer's 'commentstring'. Does nothing when it
" is empty. Give ! to enable indented paragraph folding.
"
" Defines folds with a fold level equal to the number of times the last
" character (ignoring whitespace) of the first part of 'commentstring' is
" repeated (not including the first occurrence) at the start of line. For
" example, if 'commentstring' is `/* %s */`, `/**` starts a level 1 fold,
" `/***` starts a level 2 fold, etc.
command -bar -bang -nargs=0 UnobtrusiveFoldComment
\ call unobtrusive_fold#comment(<q-bang>)

"" :UnobtrusiveFoldChar

""
" Sets the current window's 'foldmethod', 'foldexpr' and plugin-internal
" variables based on {char}. Lines in syntax groups whose names contain
" "Comment", "Code", or "Snippet" are ignored. Give ! to enable indented
" paragraph folding.
"
" Defines folds with a fold level equal to the number of times {char} is
" repeated at the start of line (including the first occurrence) at the start
" of line. For example, if {char} is `#`, `#` starts a level 1 fold, `##`
" starts a level 2 fold, etc.
command -bar -bang -nargs=1 UnobtrusiveFoldChar
\ call unobtrusive_fold#char(<q-bang>, <f-args>)

"" :UnobtrusiveFoldDebug

""
" Inserts the return value of 'foldexpr' and the effective |foldlevel()| into
" the leftmost columns of the current buffer.
command -bar -nargs=0 UnobtrusiveFoldDebug
\ call unobtrusive_fold#debug()
