# [`vim-unobtrusive-fold`][]

A [Vim][] [plugin][] for unobtrusive [folds][].

This plugin provides an improved mix of [`'foldmethod'`][] [`marker`][] and
[`indent`][] (implemented with [`expr`][]), with markers that blend well with
the [`'filetype'`][] (based on [`'commentstring'`][] or e.g. markup headings)
and optional nested indented paragraph folds. It ends folds automatically when
indentation drops and allocates empty lines to folds in such a way that it is
easy to identify folds of different levels (creating a nice table of content
when almost all folds are closed), without explicit end markers.

Also provided is a [`'foldtext'`][] function and a command to debug
[`'foldexpr'`][]s.

[`vim-unobtrusive-fold`]: https://git.rcrnstn.net/rcrnstn/vim-unobtrusive-fold
[Vim]: https://en.wikipedia.org/wiki/Vim_(text_editor)
[plugin]: https://vimhelp.org/usr_05.txt.html#plugin
[folds]: https://vimhelp.org/folds.txt.html#folds
[`'foldmethod'`]: https://vimhelp.org/options.txt.html#%27foldmethod%27
[`marker`]: https://vimhelp.org/fold.txt.html#fold-marker
[`indent`]: https://vimhelp.org/fold.txt.html#fold-indent
[`expr`]: https://vimhelp.org/fold.txt.html#fold-expr
[`'filetype'`]: https://vimhelp.org/options.txt.html#%27filetype%27
[`'commentstring'`]: https://vimhelp.org/options.txt.html#%27commentstring%27
[`'foldtext'`]: https://vimhelp.org/options.txt.html#%27foldtext%27
[`'foldexpr'`]: https://vimhelp.org/options.txt.html#%27foldexpr%27

## Usage

See the [documentation](doc/unobtrusive-fold.txt) for details about usage.

## Demo

![vimrc](doc/demo-vimrc.svg)

![yaml](doc/demo-yaml.svg)

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc/
[`LICENSE`]: LICENSE
