# [`vim-gitadd`][]

A 14-line [Vim][] "plugin manager" using [Git][] and [`:packadd`][].

Annoyed by having to [bootstrap plugin manager plugins][vim-plug-installation]?
By having to run a [separate install step][vim-plug-pluginstall] even though
you explicitly said you wanted a plugin in your `vimrc`? Tired of your plugin
manager doing [weird, hard to debug][vim-plug-issues] things behind your back?
Concerned that GitHub is becoming the [implicit custodian][vim-plug-url-format]
of all of the worlds software? <small>*(I bully [`vim-plug`][] here, probably
undeservedly, because it is the most popular. I used it for a long time and
it's great!)*</small>

Give this a try in your [`vimrc`][]!

```vim
" https://git.rcrnstn.net/rcrnstn/vim-gitadd
" Make sure to not enable |:syntax| or |:filetype| until all plugins that
" interact with them have been added! See |:packadd|.
command! -bar -bang -nargs=+ GitAdd call s:GitAdd(<q-bang>, <f-args>)
function! s:GitAdd(bang, url, ...) abort
  let name = split(a:url, '/')[-1]
  let dir = split(&packpath, ',')[0] . '/pack/gitadd/opt/' . name
  if !isdirectory(dir)
    silent execute '!git clone --recurse-submodules' join(a:000) a:url dir
    if isdirectory(dir . '/doc')
      execute 'helptags' dir . '/doc'
    endif
  endif
  if empty(a:bang)
    execute 'packadd!' name
  endif
endfunction
```

Any arguments that [`git clone`][] accepts, e.g. [`--branch`][] or
[`--depth`][], can be given after the URL.

Requiring the full URL might be slightly annoying, but it is self-documenting,
works with [`netrw-gx`][], and does not discriminate against non-GitHub
repositories by making them stick out like a sore thumb.

No "update plugins" command? Nope. You know what tool is great at handling
different versions of software? Git! A Git alias/shell function helps,
something to the effect of `for dir in *; do echo "=== $dir ==="; git -C "$dir"
"$@"; done`.

[`vim-gitadd`]: https://git.rcrnstn.net/rcrnstn/vim-gitadd
[Vim]: https://en.wikipedia.org/wiki/Vim_(text_editor)
[Git]: https://en.wikipedia.org/wiki/Git
[`:packadd`]: https://vimhelp.org/repeat.txt.html#%3Apackadd
[vim-plug-installation]: https://github.com/junegunn/vim-plug/blob/0.11.0/README.md#installation
[vim-plug-pluginstall]: https://github.com/junegunn/vim-plug/blob/0.11.0/README.md#pluginstall-and-plugupdate
[vim-plug-issues]: https://github.com/junegunn/vim-plug/issues?q=
[vim-plug-url-format]: https://github.com/junegunn/vim-plug/blob/0.11.0/doc/plug.txt#L231
[`vim-plug`]: https://github.com/junegunn/vim-plug
[`vimrc`]: https://vimhelp.org/starting.txt.html#vimrc
[`git clone`]: https://git-scm.com/docs/git-clone
[`--branch`]: https://git-scm.com/docs/git-clone#Documentation/git-clone.txt---branchltnamegt
[`--depth`]: https://git-scm.com/docs/git-clone#Documentation/git-clone.txt---depthltdepthgt
[`netrw-gx`]: https://vimhelp.org/pi_netrw.txt.html#netrw-gx

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc
[`LICENSE`]: LICENSE
