# [`readline-vim`][]

Upgrade [Readline][] from [`vi`][] to [Vim][].

[`readline-vim`][] is a Python program that generates [Readline][] macros that
provide [Vim][] [motions][], [operators][] and [text objects][] (that are
useful on a single line).

[`readline-vim`]: https://git.rcrnstn.net/rcrnstn/readline-vim
[Python]: https://www.python.org
[Readline]: https://en.wikipedia.org/wiki/Readline
[`vi`]: https://en.wikipedia.org/wiki/vi
[Vim]: https://en.wikipedia.org/wiki/Vim
[motions]: https://vimhelp.org/motion.txt.html
[operators]: https://vimhelp.org/motion.txt.html#operator
[text objects]: https://vimhelp.org/motion.txt.html#text-objects

## Background

[Readline][] is a library that provides line-editing for interactive
command-line programs. It is used in a great many places, including shells such
as [Bash][] (where it originated) and [REPL][]s such as [Python][] or
[Octave][]. Using [`rlwrap`][], Readline can even be used with programs that
doesn't have built in support for it, such as Matlab (as in `lrwrap -a matlab
-nodesktop -nosplash`). These factors make it fairly ubiquitous.

Readline can be configured with an `inputrc` file, usually placed at
`~/.inputrc`.

Readline uses [Emacs][]-like key bindings by default. If you're a Vim fan
though, you probably use its `vi` mode, activated by `set editing-mode vi` in
the configuration or through some mechanism in the containing program, such as
Bash's `set -o vi`.

If you *are* a Vim fan though, this has the potential of landing you in a sort
of [uncanny valley][] since (Readline's) `vi` (mode) does not include the many
improvements contained in Vim that you have come to rely on, mainly [text
objects][].

## Usage

Clone the repository

```sh
git clone https://git.rcrnstn.net/rcrnstn/readline-vim
cd readline-vim
```

and append the output to your `~/.inputrc`

```sh
./readline-vim >> ~/.inputrc
```

## Similar projects

-   [`bash-surround`](https://github.com/liloman/bash-surround)

    Defines the macros manually and therefore "only" provides 234 of them,
    missing some functionality.

    The instructions are Bash centric, although it uses general Readline
    macros.

-   [Athame](https://github.com/ardagnir/athame)

    Patches Readline to route keystrokes through an actual Vim process. Also
    provides patches for [Zsh][]. This means that whatever your local Vim
    supports, Athame supports (including plugins)!

    Can be a little unreliable if your local Vim has a ton of plugins,
    especially if they interact with the terminal in non-obvious ways.

-   [`readline-vim`](https://github.com/thlorenz/readline-vim)

    Exclusive to [Node.js][] [`readline`][Node.js `readline`] and only defines
    `vi` bindings, not Vim.

[Node.js]: https://nodejs.org
[Node.js `readline`]: https://nodejs.org/api/readline.html#readline_readline
[Zsh]: https://en.wikipedia.org/wiki/Zsh

## License

Licensed under the [ISC License][], see the [`LICENSE`](LICENSE) file.

[ISC License]: https://choosealicense.com/licenses/isc/
