# [`raspi-revcode`][]

Parse [Raspberry Pi revision codes][].

[`raspi-revcode`]: https://git.rcrnstn.net/rcrnstn/raspi-revcode
[Raspberry Pi revision codes]: https://www.raspberrypi.com/documentation/computers/raspberry-pi.html#raspberry-pi-revision-codes

## Usage

`raspi-revcode --help`:

```
usage:
  raspi-revcode [<code>]
  raspi-revcode -h|--help
  raspi-revcode --version

Parse Raspberry Pi revision codes.

positional arguments:
  <code>
    A hexadecimal revision code to parse. If not given, '/proc/cpuinfo' will be
    used to get the revision code of the current device.

optional arguments:
  -h, --help
    Show this help message and exit.
  --version
    Show program's version number and exit.
```

## Examples

The following example shows calling `raspi-revcode` from the shell, and the
produced output:

```
$ raspi-revcode 0012
Type         : A+
Revision     : 1.1
Memory size  : 256MB
Manufacturer : Sony UK
New flag     : Old-style revision
Warranty bit : Warranty is intact

$ raspi-revcode 900021
Revision     : 1.1
Type         : A+
Processor    : BCM2835
Manufacturer : Sony UK
Memory size  : 512MB
New flag     : New-style revision
Warranty bit : Warranty is intact
OTP Read     : OTP reading allowed
OTP Program  : OTP programming allowed
Overvoltage  : Overvoltage allowed

$ raspi-revcode ffffffff
Revision     : 1.15
Type         : <UNEXPECTED BITS 11111111>
Processor    : <UNEXPECTED BITS 1111>
Manufacturer : <UNEXPECTED BITS 1111>
Memory size  : <UNEXPECTED BITS 111>
New flag     : New-style revision
Unused       : <UNEXPECTED BITS 1>
Warranty bit : Warranty has been voided by overclocking
Unused       : <UNEXPECTED BITS 111>
OTP Read     : OTP reading disallowed
OTP Program  : OTP programming disallowed
Overvoltage  : Overvoltage disallowed
```

## Install

### Prerequisites

Make sure [Python is installed][Python download], [`pip`][] is available and
the [`pip`][], [`setuptools`][] and [`wheel`][] packages are up to date:

```sh
python3 -m pip install --user --upgrade pip setuptools wheel
```

Reference: [Python Packaging User Guide: Requirements for Installing
Packages][].

[Python download]: https://python.org/download
[`pip`]: https://pip.readthedocs.io
[`setuptools`]: https://setuptools.readthedocs.io
[`wheel`]: https://wheel.readthedocs.io
[Python Packaging User Guide: Requirements for Installing Packages]: https://packaging.python.org/tutorials/installing-packages/#requirements-for-installing-packages

### With [`pipx`][], for users

Make sure [`pipx`][] is installed:

```sh
python3 -m pip install --user pipx
```

Install `raspi-revcode`:

```sh
pipx install "git+https://git.rcrnstn.net/rcrnstn/raspi-revcode"
```

`raspi-revcode` should now be in your [`PATH`][] (if not, run `python3 -m pipx
ensurepath`).

Reference: [Python Packaging User Guide: Installing stand alone command line
tools][].

[`pipx`]: https://pipxproject.github.io/pipx/
[`PATH`]: https://en.wikipedia.org/wiki/PATH_(variable)
[Python Packaging User Guide: Installing stand alone command line tools]: https://packaging.python.org/guides/installing-stand-alone-command-line-tools/

### Into [`venv`][], for developers

Clone and install into a repository [`venv`][] virtual environment:

```sh
git clone "https://git.rcrnstn.net/rcrnstn/raspi-revcode"
cd "raspi-revcode"
python3 -m venv .venv
. .venv/bin/activate
python3 -m pip install --editable .
```

`raspi-revcode` should now be in your (virtual environment) [`PATH`][].

Reference: [Python Packaging User Guide: Installing packages using pip and
virtual environments][].

[`venv`]: https://docs.python.org/3/library/venv.html
[Python Packaging User Guide: Installing packages using pip and virtual environments]: https://packaging.python.org/guides/installing-using-pip-and-virtual-environments/

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc
[`LICENSE`]: LICENSE
