from setuptools import setup

with open("README.md") as f:
    long_description = f.read()

setup(
    name='raspi-revcode',
    version='1.0.0',
    description="""
        Parse Raspberry Pi revision codes.
    """,
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://git.rcrnstn.net/rcrnstn/raspi-revcode',
    author="Robert Cranston",
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: ISC License (ISCL)',
    ],
    python_requires='>=3, <4',
    install_requires=[
        'docopt',
    ],
    py_modules=['raspi_revcode'],
    entry_points={
        'console_scripts': [
            'raspi-revcode = raspi_revcode:main',
        ],
    },
)
