from setuptools import setup

with open("README.md") as f:
    long_description = f.read()

setup(
    name='pyffstream',
    version='1.0.0',
    description="Python library to ease processing of video frames",
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://git.rcrnstn.net/rcrnstn/pyffstream',
    author="Robert Cranston",
    keywords='ffmpeg opencv',
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: ISC License (ISCL)',
    ],
    python_requires='>=3.3, <4',  # shlex.quote
    install_requires=[
        'ffmpeg-python',
        'numpy',
        'Pillow',
        'opencv-python',
    ],
    py_modules=['pyffstream'],
)
