# [`mpv-gpu-rotate`][]

Rotate [`mpv`][] videos by [arbitrary angles on the GPU][].

[`mpv-gpu-rotate`]: https://git.rcrnstn.net/rcrnstn/mpv-gpu-rotate
[`mpv`]: https://mpv.io
[arbitrary angles on the GPU]: https://github.com/mpv-player/mpv/issues/3434#issuecomment-275195855

## Installation

Copy or [symlink][] the following file into the [`mpv` configuration
directory][], preserving subdirectories:

-   [`scripts/gpu_rotate.lua`][]

Example usage configuration can be found in:

-   [`mpv.conf.example`][]
-   [`input.conf.example`][]

On Unix-likes, creating symlinks can be done automatically by [`stow`][] by
running the following from the repository root:

```sh
stow --no-folding --ignore='\.example$' --target="$HOME/.config/mpv" .
```

[symlink]: https://en.wikipedia.org/wiki/Symbolic_link
[`mpv` configuration directory]: https://mpv.io/manual/master/#files
[`scripts/gpu_rotate.lua`]: scripts/gpu_rotate.lua
[`mpv.conf.example`]: mpv.conf.example
[`input.conf.example`]: input.conf.example
[`stow`]: https://www.gnu.org/software/stow/

## Contributing

Lint with [`luacheck`][].

[`luacheck`]: https://github.com/mpeterv/luacheck

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc
[`LICENSE`]: LICENSE
