#include <iomanip>
#include <iostream>
#include <string>
#include <type_traits>

#include <glm/glm.hpp>

#include <glbase.hpp>
#include <gltraits.hpp>


struct GLTraitsTest : protected GLBase
{

    template<typename Value>
    void static test_value()
    {
        using Traits = GLTraits::Value<Value>;
        static_assert(
            std::is_empty<Traits>::value,
            "GLTraits::Value must be empty"
        );
        #define GLTRAITS_TEST_VALUE(NAME, VALUE) \
            << std::left << std::setw(35) << "  " NAME ":" << VALUE << "\n"
        #define GLTRAITS_TEST_VALUE_DEC(NAME) \
            GLTRAITS_TEST_VALUE(#NAME, std::dec << Traits::NAME)
        #define GLTRAITS_TEST_VALUE_BOOL(NAME) \
            GLTRAITS_TEST_VALUE(#NAME, std::boolalpha << Traits::NAME)
        #define GLTRAITS_TEST_VALUE_HEX(NAME) \
            GLTRAITS_TEST_VALUE(#NAME, str_enum_(Traits::NAME))
        #define GLTRAITS_TEST_VALUE_ENUM(NAME, SUFFIX) \
            GLTRAITS_TEST_VALUE( \
                #NAME #SUFFIX, \
                str_##NAME##_(Traits::NAME##SUFFIX) \
            )
        std::cout
            << "Value<" << Traits::name << ">" << "\n"
            GLTRAITS_TEST_VALUE_DEC(columns)
            GLTRAITS_TEST_VALUE_DEC(rows)
            GLTRAITS_TEST_VALUE_ENUM(glsl,)
            GLTRAITS_TEST_VALUE_ENUM(format,)
            GLTRAITS_TEST_VALUE_ENUM(type,)
            GLTRAITS_TEST_VALUE_ENUM(internal_format,)
            GLTRAITS_TEST_VALUE_ENUM(internal_format, _srgb)
            GLTRAITS_TEST_VALUE_ENUM(internal_format, _compressed)
            GLTRAITS_TEST_VALUE_ENUM(internal_format, _compressed_srgb)
            GLTRAITS_TEST_VALUE_BOOL(integer)
            GLTRAITS_TEST_VALUE_HEX(id);
    }

    template<GLenum id>
    void static test_value_id()
    {
        using Traits = GLTraits::ValueID<id>;
        static_assert(
            std::is_empty<Traits>::value,
            "GLTraits::ValueID must be empty"
        );
        std::cout
            << "ValueID<" << str_enum_(id) << ">" << "\n"
            << "  " << GLTraits::Value<typename Traits::Value>::name << "\n";
    }

    template<GLenum object_type, typename... Args>
    void static test_object()
    {
        using Traits = GLTraits::Object<object_type>;
        static_assert(
            std::is_empty<Traits>::value,
            "GLTraits::Object must be empty"
        );
        #define GLTRAITS_TEST_OBJECT(NAME) \
            << std::left << std::setw(33) \
            << "  " #NAME ":" \
            << (void *)Traits::NAME \
            << "\n"
        std::cout
            << "Object<" << Traits::name << ">" << "\n"
            GLTRAITS_TEST_OBJECT(template gen_objects<Args...>)
            GLTRAITS_TEST_OBJECT(delete_objects)
            GLTRAITS_TEST_OBJECT(info_log);
    }

};


int main()
{
    GLTraitsTest::test_value<GLfloat>();
    GLTraitsTest::test_value<bool>();
    GLTraitsTest::test_value<GLshort>();
    GLTraitsTest::test_value<GLdouble>();
    GLTraitsTest::test_value<glm::mat4x3>();
    GLTraitsTest::test_value<glm::uvec2>();
    GLTraitsTest::test_value<glm::dvec2>();

    GLTraitsTest::test_value_id<GL_FLOAT>();
    GLTraitsTest::test_value_id<GL_BOOL>();
    GLTraitsTest::test_value_id<GL_SHORT>();
    GLTraitsTest::test_value_id<GL_DOUBLE>();
    GLTraitsTest::test_value_id<GL_FLOAT_MAT4x3>();
    GLTraitsTest::test_value_id<GL_UNSIGNED_INT_VEC2>();
    GLTraitsTest::test_value_id<GL_DOUBLE_VEC2>();

    GLTraitsTest::test_object<GL_SHADER, GLenum>();
    GLTraitsTest::test_object<GL_PROGRAM_PIPELINE>();
}
