#include <cstddef>

#include <glm/glm.hpp>

#include <glbase.hpp>
#include <gltraits.hpp>


template<
    typename    T,
    typename    Value,
    std::size_t offset,
    typename... Members
>
void vertex_setup(
    GLTraits::Members<T, GLTraits::Member<Value, offset>, Members...>,
    GLint location = 0
)
{
    GLTraits::Value<Value>::vertex_attrib_pointer(location, offset, sizeof(T));
    vertex_setup(
        GLTraits::Members<T, Members...>{},
        location + GLTraits::Value<Value>::columns
    );
}
template<typename T>
void vertex_setup(GLTraits::Members<T>, GLint)
{}


int main()
{
    struct Vertex
    {
        glm::vec3  position;
        glm::vec2  tex_coord;
        glm::mat3  tbn;
        glm::ivec4 bone_indices;
        glm::vec4  bone_weights;
        GLubyte    flags;
        GLdouble   unaligned;
    };
    vertex_setup(GLTraits::members<Vertex>());
}
