#include <cstddef>

#include <glm/glm.hpp>

#include <glbase.hpp>
#include <gltraits.hpp>


template<
    typename    Value,
    typename... Values
>
void vertex_setup(
    GLTraits::Members<Value, Values...>,
    std::size_t stride,
    std::size_t offset   = 0,
    GLint       location = 0
)
{
    auto unaligned = offset % alignof(Value);
    if (unaligned)
        offset += alignof(Value) - unaligned;
    GLTraits::Value<Value>::vertex_attrib_pointer(location, offset, stride);
    vertex_setup(
        GLTraits::Members<Values...>{},
        stride,
        offset   + sizeof(Value),
        location + GLTraits::Value<Value>::columns
    );
}
void vertex_setup(GLTraits::Members<>, std::size_t, std::size_t, GLint)
{}


int main()
{
    struct Vertex
    {
        glm::vec3  position;
        glm::vec2  tex_coord;
        glm::mat3  tbn;
        glm::ivec4 bone_indices;
        glm::vec4  bone_weights;
        GLubyte    flags;
        GLdouble   unaligned;
    };
    vertex_setup(GLTraits::members<Vertex>(), sizeof(Vertex));
}
