#include <gltexture2d.hpp>

#include <ostream>

#include <globject.hpp>

// NOLINTNEXTLINE
#define STR_EXCEPTION GLObject<>::Exception
#include <str.hpp>


/// TGA


GLTexture2D GLTexture2D::tga_read(
    Path const & path,
    GLenum       format,
    GLenum       internal_format,
    GLenum       wrap,
    GLenum       min_filter,
    GLenum       mag_filter
)
try
{
    auto texture = GLTexture2D(
        str_path_(path),
        TGA::read(path).size(),
        internal_format,
        wrap,
        min_filter,
        mag_filter
    );
    texture.data(
        TGA::read(path_prefix_(path, prefix())).data(),
        GL_TEXTURE_2D,
        format
    );
    return texture;
}
catch (...)
{
    STR_THROW_NESTED(
        "Failed to read GLTexture2D TGA " << str_path_(path) << ":"
    );
}


void GLTexture2D::tga_write(
    Path const & path,
    GLenum       format
) const
try
{
    TGA(size(), data(GL_TEXTURE_2D, format))
        .write(path_prefix_(path, prefix()));
}
catch (...)
{
    STR_THROW_NESTED(
        "Failed to write GLTexture2D TGA " << str_path_(path) << ":"
    );
}
