#ifndef GLTEXTUREND_HPP_
#define GLTEXTUREND_HPP_


#include <array>
#include <cstddef>
#include <string>

#include <globject.hpp>
#include <gltexture.hpp>


/// Class

template<std::size_t N>
class GLTextureND : public GLTexture
{
public:

    /// Special member functions

    using Size = std::array<GLsizei, N>;

    explicit GLTextureND(
        std::string object_label,
        GLenum      target,
        GLenum      binding,
        GLenum      size_max_name,
        Size        size,
        GLenum      internal_format = 0,
        GLenum      wrap            = 0,
        GLenum      min_filter      = 0,
        GLenum      mag_filter      = 0
    );

    /// Core

    GLOBJECT_GET(Size, size);

protected:

    /// Core

    std::size_t virtual data_size_() const override;

    /// Check

    void check_size_max_(GLenum size_max_name);

    /// String

    std::string static str_size_(Size size);

private:

    /// Core

    Size const size_;
};


/// Explicit template instantiation

extern template class GLTextureND<1>;
extern template class GLTextureND<2>;
extern template class GLTextureND<3>;


#endif // GLTEXTUREND_HPP_
