#ifndef GLTEXTURE1D_HPP_
#define GLTEXTURE1D_HPP_


#include <string>
#include <utility>

#include <gltexturend.hpp>


/// Class

class GLTexture1D : public GLTextureND<1>
{
public:

    /// Special member functions

    explicit GLTexture1D(
        std::string object_label,
        Size        size,
        GLenum      internal_format = GL_RGBA8,
        GLenum      wrap            = GL_CLAMP_TO_EDGE,
        GLenum      min_filter      = GL_LINEAR,
        GLenum      mag_filter      = GL_LINEAR
    );

    /// Core

    GLTexture1D static const & empty();

private:

    /// Core

    void virtual data_(
        void const * data,
        GLenum       target,
        GLenum       format,
        GLenum       type
    ) override;
};


/// Special member functions

inline GLTexture1D::GLTexture1D(
    std::string object_label,
    Size        size,
    GLenum      internal_format,
    GLenum      wrap,
    GLenum      min_filter,
    GLenum      mag_filter
)
:
    GLTextureND(
        std::move(object_label),
        GL_TEXTURE_1D,
        GL_TEXTURE_BINDING_1D,
        GL_MAX_TEXTURE_SIZE,
        size,
        internal_format,
        wrap,
        min_filter,
        mag_filter
    )
{
    try
    {
        glTexImage1D(
            target_, 0,
            (GLint)internal_format,
            size[0], 0,
            GL_RED, GL_UNSIGNED_BYTE, nullptr
        );
        check_error_(glGetError());
    }
    catch (...)
    {
        fail_action_("create");
    }
}

/// Core

inline GLTexture1D const & GLTexture1D::empty()
{
    return empty_<GLTexture1D>();
}

inline void GLTexture1D::data_(
    void const * data,
    GLenum       target,
    GLenum       format,
    GLenum       type
)
{
    glTexSubImage1D(
        target, 0,
        0,
        size()[0],
        format, type, data
    );
}


#endif // GLTEXTURE1D_HPP_
