#include <string>

#include <gltexture.hpp>
#include <gltexture1d.hpp>
#include <gltexture2d.hpp>
#include <gltexture3d.hpp>
#include <gltexturebuffer.hpp>
#include <gltexturecubemap.hpp>


constexpr auto size = 128;


template<typename Data>
void texture(GLuint program, GLTexture * texture0)
{
    // NOLINTNEXTLINE
    GLTexture::anisotropy(4.0F);

    glUniform1i(
        glGetUniformLocation(program, "texture0"),
        texture0->unit()
    );

    auto const data = texture0->data<Data>();
    (void)data;
    texture0->data({1, 2, 3, 4});
    texture0->clear();
}


int main()
{
    GLTexture1D              texture1d     ("", {size});
    GLTexture2D              texture2d     ("", {size, size});
    GLTexture3D              texture3d     ("", {size, size, size});
    GLTextureBuffer<GLfloat> texturebuffer ("", {size});
    GLTextureCubemap         texturecubemap("", {size, size});
}
