#include <cerrno>
#include <cstring>
#include <fstream>
#include <stdexcept>
#include <string>

#include <GL/glew.h>

#include <glbackend.hpp>
#include <gltest.hpp>


// Function that throws with a system-supplied message.
void file_open(std::string const & filename)
{
    auto file = std::ifstream{"nonexistent"};
    if (!file)
        throw std::runtime_error(std::string{} +
            "Could not open file '" + filename + "':\n" +
            std::strerror(errno) + "." // NOLINT
        );
}


GLTEST(gltest, 640, 480, 2, 0)
{
    backend.prefix("assets/tests");

    GLTEST_EXPECT_VALUE(
        GL_FALSE,
        glIsEnabled(GL_DEPTH_TEST)
    )
    GLTEST_EXPECT_EXCEPTION(false,
        "Expected exception",
        throw std::runtime_error("Expected exception")
    )
    GLTEST_EXPECT_EXCEPTION(true,
        "Could not open file 'nonexistent':\n",
        // "No such file or directory"
        file_open("nonexistent")
    )

    constexpr auto size = 0.5;
    glBegin(GL_TRIANGLE_STRIP);
    glVertex3f(-size, -size, 0);
    glVertex3f(-size, +size, 0);
    glVertex3f(+size, -size, 0);
    glVertex3f(+size, +size, 0);
    glEnd();
    backend.tga_compare("GLTest.tga");
}
