#include <gltest.hpp>

#include <stdexcept>
#include <string>

#include <glbackend_default.hpp>


std::vector<GLTest_> & gltests_()
{
    auto static tests = std::vector<GLTest_>{};
    return tests;
}


int main()
{
    for (auto const & test : gltests_())
    {
        auto error = std::string{};
        auto backend = GLBackendDefault(
            test.title,
            {test.width, test.height},
            {test.version_major, test.version_minor}
        );
        backend.debug_callback([&](std::string const & message)
        {
            if (error.empty())
                error = message;
        });
        test.func(backend);
        if (!error.empty())
            throw std::runtime_error{error};
    }
}
