#version 150


layout(triangles) in;
layout(line_strip, max_vertices = 6) out;


uniform mat4  view_projection;
uniform float scale;


in vec4 geom_normal[3];


void primitive_(int i)
{
    gl_Position = view_projection *
        (gl_in[i].gl_Position);
    EmitVertex();
    gl_Position = view_projection *
        (gl_in[i].gl_Position + scale * geom_normal[i]);
    EmitVertex();
    EndPrimitive();
}


void main()
{
    primitive_(0);
    primitive_(1);
    primitive_(2);
}
