# [`glvisnormals`][]

A [GLSL][]/[OpenGL][] [\>=3.2][] [normal][] visualization library.

A [geometry shader][] is used to visualize the normals from the same geometry
as when drawing normally.

[`glvisnormals`]: https://git.rcrnstn.net/rcrnstn/glvisnormals
[GLSL]: https://en.wikipedia.org/wiki/OpenGL_Shading_Language
[OpenGL]: https://en.wikipedia.org/wiki/OpenGL
[\>=3.2]: https://en.wikipedia.org/wiki/OpenGL#Version_history
[normal]: https://en.wikipedia.org/wiki/Normal_(geometry)
[geometry shader]: https://www.khronos.org/opengl/wiki/Geometry_Shader

## Requirements

[Geometry shader][]s require OpenGL [\>=3.2][] or the
[`ARB_geometry_shader4`][] extension.

[`ARB_geometry_shader4`]: https://www.khronos.org/registry/OpenGL/extensions/ARB/ARB_geometry_shader4.txt

## Usage

Link the shader program with:

-   `visnormals.vert`
-   `visnormals.geom`
-   `visnormals.frag`

The following vertex attributes need to be set:

-   `vec3 vert_position`
-   `vec3 vert_normal` (assumed to be of unit length)
-   `mat4 vert_model` (assumed to be an isometry, i.e. no scaling or skewing)

The following uniforms need to be set:

-   `mat4  view_projection`
-   `float scale`
-   `vec4  color`

The following outputs are written by the fragment shader:

-   ` vec4 frag_color`

Make the shader program current and issue the same draw call as would be done
when drawing normally.

## Build system

This project has support for [CMake][], and uses [`cmake-cxx`][].

There are several ways to use this project in another CMake-based project:

-   Use [`FetchContent`][] to download it and import the targets automatically
    as part of the configure step:

    ```cmake
    include(FetchContent)
    FetchContent_Declare(project-name
        GIT_REPOSITORY https://example.com/user/project-name
    )
    FetchContent_MakeAvailable(
        project-name
    )
    ```

-   Bundle it and import the targets with [`add_subdirectory`][].

-   Use [`find_package`][] (requires that the project is [packaged](#packaging)
    or [installed](#installing)).

As usual, use [`add_dependencies`][]/[`target_link_libraries`][] to declare the
dependency.

[CMake]: https://cmake.org
[`cmake-cxx`]: https://git.rcrnstn.net/rcrnstn/cmake-cxx
[`FetchContent`]: https://cmake.org/cmake/help/v3.14/module/FetchContent.html
[`add_subdirectory`]: https://cmake.org/cmake/help/v3.14/command/add_subdirectory.html
[`find_package`]: https://cmake.org/cmake/help/v3.14/command/find_package.html
[`add_dependencies`]: https://cmake.org/cmake/help/v3.14/command/add_dependencies.html
[`target_link_libraries`]: https://cmake.org/cmake/help/v3.14/command/target_link_libraries.html

### Configure and generate

To configure and generate a build tree, use `cmake`:

```sh
cmake -B build
```

To set the [`CMAKE_BUILD_TYPE`][], pass e.g. `-DCMAKE_BUILD_TYPE=Release`.

[`cmake`]: https://cmake.org/cmake/help/v3.14/manual/cmake.1.html#generate-a-project-buildsystem
[`CMAKE_BUILD_TYPE`]: https://cmake.org/cmake/help/v3.14/variable/CMAKE_BUILD_TYPE.html

### Build

To build, use [`cmake --build`][]:

```sh
cmake --build build
```

[`cmake --build`]: https://cmake.org/cmake/help/v3.14/manual/cmake.1.html#build-a-project

### Test

To run tests, use [`ctest`][]:

```sh
(cd build && ctest --output-on-failure)
```

[`ctest`]: https://cmake.org/cmake/help/v3.14/manual/ctest.1.html

### Package

To package, use [`cpack`][]:

```sh
(cd build && cpack)
```

[`cpack`]: https://cmake.org/cmake/help/v3.14/manual/cpack.1.html

### Install

To install onto the current system, use [`cmake --install`][]:

```sh
cmake --install build
```

[`cmake --install`]: https://cmake.org/cmake/help/v3.14/manual/cmake.1.html#install-a-project

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`](LICENSE) file.

[ISC License]: https://choosealicense.com/licenses/isc/
