# [`glslrun`][]

Run [GLSL][] code on the CPU.

Generates a wrapper file including some [C++][] standard library functionality
and [OpenGL Mathematics (GLM)][], compiles it with the systems C++ compiler (by
default [`gcc`][], can be changed by setting the [environment variable][]
`CXX`) and runs the result.

This, of course, does not *really* run GLSL code on the CPU. For an actual GLSL
compiler (but not to something that can run on the CPU), see [`glslang`][].

The wapper does the following:

-   C++ standard library
    -   Brings the `std` namespace into global scope.
    -   `#include`s [`cassert`][] for testing.
    -   `#include`s [`iostream`][] for printing.
-   GLM
    -   Brings the `glm` namespace into global scope.
    -   `#define`s `GLM_FORCE_SWIZZLE` to enable [swizzling][] support.
    -   `#include`s [`glm/gtx/io.hpp`][] to enable [`iostream`][] support.
-   Other
    -   `#define`s `GLSLRUN`.
    -   Defines [built-in variable][]s (like [`gl_Position`][]).
    -   Defines [built-in function][]s (like [`EmitVertex`][]).

[`glslrun`]: https://git.rcrnstn.net/rcrnstn/glslrun
[GLSL]: https://en.wikipedia.org/wiki/OpenGL_Shading_Language
[C++]: https://en.wikipedia.org/wiki/C++
[OpenGL Mathematics (GLM)]: https://glm.g-truc.net
[`gcc`]: https://gcc.gnu.org
[environment variable]: https://en.wikipedia.org/wiki/Environment_variable
[`glslang`]: https://github.com/KhronosGroup/glslang
[`cassert`]: https://en.cppreference.com/w/cpp/header/cassert
[`iostream`]: https://en.cppreference.com/w/cpp/header/iostream
[swizzling]: https://en.wikipedia.org/wiki/Swizzling_(computer_graphics)
[`glm/gtx/io.hpp`]: http://glm.g-truc.net/0.9.9/api/a00332.html
[built-in variable]: https://www.khronos.org/opengl/wiki/Built-in_Variable_(GLSL)
[`gl_Position`]: https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/gl_Position.xhtml
[built-in function]: https://www.khronos.org/opengl/wiki/Built-in_Function_(GLSL)
[`EmitVertex`]: https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/EmitVertex.xhtml

## Usage

`glslrun --help`:

```
glslrun 1.0

Run GLSL code snippets on the CPU.

usage:
  glslrun [options] [--] [<file>]
  glslrun -h|--help
  glslrun --version

arguments:
  <file>
    File containing code to run. If <file> is omitted or -, to read from
    stdin instead.

options:
  -m, --main
    Generate an enclosing main() function.

  -p, --print
    Print the generated code that is passed to the compiler.
```

## Dependencies

For compiling C++:

-   C++ compiler (e.g. from [`g++`][])
-   C++ standard library (e.g. from [`libstdc++`][])
-   OpenGL Mathematics (GLM) (e.g. from [`libglm-dev`][])

All other dependencies are [POSIX][] (except `mktemp`, but most Unix-like
systems have some version), and are highly likely to be installed by default
(e.g. they all have the [Debian priority][] `required`).

-   `sh` (e.g. from [`bash`][] or [`dash`][])
-   `rm`, `cat`, `mktemp` (e.g. from [`coreutils`][])
-   `sed` (e.g. from [`sed`][])
-   `awk` (e.g. from [`mawk`][])

[`g++`]: https://packages.debian.org/g++
[`libstdc++`]: https://packages.debian.org/libstdc++
[`libglm-dev`]: https://packages.debian.org/libglm-dev
[POSIX]: https://en.wikipedia.org/wiki/POSIX
[Debian priority]: https://www.debian.org/doc/debian-policy/ch-archive.html#s-priorities
[`bash`]: https://packages.debian.org/bash
[`coreutils`]: https://packages.debian.org/coreutils
[`dash`]: https://packages.debian.org/dash
[`sed`]: https://packages.debian.org/sed
[`mawk`]: https://packages.debian.org/mawk

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`](LICENSE) file.

[ISC License]: https://choosealicense.com/licenses/isc/
