# [`glslrun`][]

Run [GLSL][] code on the CPU.

[`glslrun`]: https://git.rcrnstn.net/rcrnstn/glslrun
[GLSL]: https://en.wikipedia.org/wiki/OpenGL_Shading_Language

## Usage

`glslrun --help`:

```
glslrun 1.0

Run GLSL code snippets on the CPU.

usage:
  glslrun [options] [--] [<file>]
  glslrun -h|--help
  glslrun --version

arguments:
  <file>
    File containing code to run. Specify - to read from stdin instead.

options:
  -m, --main
    Generate an enclosing main() function.

  -p, --print
    Print the generated code that is passed to the compiler.
```

## Dependencies

All dependencies are [POSIX][] and are highly likely to be installed by default
(e.g. they all have the [Debian priority][] `required`).

-   `sh` (e.g. from [`bash`][] or [`dash`][])
-   `sed` (e.g. from [`sed`][])
-   `awk` (e.g. from [`mawk`][])

[POSIX]: https://en.wikipedia.org/wiki/POSIX
[Debian priority]: https://www.debian.org/doc/debian-policy/ch-archive.html#s-priorities
[`bash`]: https://packages.debian.org/bash
[`dash`]: https://packages.debian.org/dash
[`sed`]: https://packages.debian.org/sed
[`mawk`]: https://packages.debian.org/mawk

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`](LICENSE) file.

[ISC License]: https://choosealicense.com/licenses/isc/
