#version 150


uniform int instance_count;


layout(points) in;
layout(triangle_strip, max_vertices = 4) out;


in int instance_id[];


out vec3 position;
out vec2 tex_coord;


void quad_vertex_(vec3 pos, int layer)
{
    position       = pos;
    tex_coord      = pos.xy * 0.5 + 0.5;
    gl_Position    = vec4(pos, 1);
    gl_Layer       = layer;
    gl_PrimitiveID = gl_PrimitiveIDIn;
    EmitVertex();
}


void main()
{
    float z = (instance_id[0] + 0.5) / instance_count * 2 - 1;
    quad_vertex_(vec3(-1, -1, z), instance_id[0]);
    quad_vertex_(vec3(-1, +1, z), instance_id[0]);
    quad_vertex_(vec3(+1, -1, z), instance_id[0]);
    quad_vertex_(vec3(+1, +1, z), instance_id[0]);
    EndPrimitive();
}
