# [`glhashnoise`][]

A [GLSL][]/[OpenGL][] [\>=2.0][] hash and noise function library.

[`glhashnoise`]: https://git.rcrnstn.net/rcrnstn/glhashnoise
[GLSL]: https://en.wikipedia.org/wiki/OpenGL_Shading_Language
[OpenGL]: https://en.wikipedia.org/wiki/OpenGL
[\>=2.0]: https://en.wikipedia.org/wiki/OpenGL#Version_history

## Build system

This project has support for [CMake][], and uses [`cmake-cxx`][].

There are several ways to use this project in another CMake-based project:

-   Use [`FetchContent`][] to download it and import the targets automatically
    as part of the configure step:

    ```cmake
    include(FetchContent)
    FetchContent_Declare(project-name
        GIT_REPOSITORY https://example.com/user/project-name
    )
    FetchContent_MakeAvailable(
        project-name
    )
    ```

-   Bundle it and import the targets with [`add_subdirectory`][].

-   Use [`find_package`][] (requires that the project is [packaged](#packaging)
    or [installed](#installing)).

As usual, use [`add_dependencies`][]/[`target_link_libraries`][] to declare the
dependency.

[CMake]: https://cmake.org
[`cmake-cxx`]: https://git.rcrnstn.net/rcrnstn/cmake-cxx
[`FetchContent`]: https://cmake.org/cmake/help/v3.14/module/FetchContent.html
[`add_subdirectory`]: https://cmake.org/cmake/help/v3.14/command/add_subdirectory.html
[`find_package`]: https://cmake.org/cmake/help/v3.14/command/find_package.html
[`add_dependencies`]: https://cmake.org/cmake/help/v3.14/command/add_dependencies.html
[`target_link_libraries`]: https://cmake.org/cmake/help/v3.14/command/target_link_libraries.html

### Configure and generate

To configure and generate a build tree, use `cmake`:

```sh
cmake -B build
```

To set the [`CMAKE_BUILD_TYPE`][], pass e.g. `-DCMAKE_BUILD_TYPE=Release`.

[`cmake`]: https://cmake.org/cmake/help/v3.14/manual/cmake.1.html#generate-a-project-buildsystem
[`CMAKE_BUILD_TYPE`]: https://cmake.org/cmake/help/v3.14/variable/CMAKE_BUILD_TYPE.html

### Build

To build, use [`cmake --build`][]:

```sh
cmake --build build
```

[`cmake --build`]: https://cmake.org/cmake/help/v3.14/manual/cmake.1.html#build-a-project

### Test

To run tests, use [`ctest`][]:

```sh
(cd build && ctest --output-on-failure)
```

[`ctest`]: https://cmake.org/cmake/help/v3.14/manual/ctest.1.html

### Package

To package, use [`cpack`][]:

```sh
(cd build && cpack)
```

[`cpack`]: https://cmake.org/cmake/help/v3.14/manual/cpack.1.html

### Install

To install onto the current system, use [`cmake --install`][]:

```sh
cmake --install build
```

[`cmake --install`]: https://cmake.org/cmake/help/v3.14/manual/cmake.1.html#install-a-project

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`](LICENSE) file.

[ISC License]: https://choosealicense.com/licenses/isc/
