#ifndef GLSHADER_SHADER_HPP_
#define GLSHADER_SHADER_HPP_


#include <set>
#include <string>

#include <GL/glew.h>


class Shader
{
public:

    using Paths = std::set<std::string>;

    explicit Shader(Paths const & paths);
    virtual ~Shader();
    Shader(Shader &&) noexcept;
    Shader(Shader const &) = delete;
    Shader & operator=(Shader &&) = delete;
    Shader & operator=(Shader const &) = delete;

    static void root(std::string const & root);

    GLuint program() const;

protected:

    GLuint             program_;
    std::string        program_name_;
    std::string static root_;
};


// Inline definitions.

#define GLSHADER_SET_(TYPE, NAME) \
    inline void Shader::NAME(TYPE const & NAME) \
    { \
        NAME##_ = NAME; \
    }
GLSHADER_SET_(std::string, root)

inline GLuint Shader::program() const
{
    return program_;
}


#endif // GLSHADER_SHADER_HPP_
