# `glshader`

A C++11 helper for [OpenGL][] >=2.0 [shaders][Shader].

`glshader` can load an arbitrary number of [shaders][Shader] with the type
autodetected by the file extension (using the same rules as the [OpenGL /
OpenGL ES Reference Compiler][]). For example:

```cpp
Shader shader({
    "test.vert",
    "test.frag",
});
shader.use();
```

Errors are handled by throwing [`std::runtime_error`][] with a [`what()`][]
that returns helpful context as well as the OpenGL info log where appropriate.
See the [tests](#tests) source for an overview of (some of) the generated error
messages.

[OpenGL]: https://www.opengl.org
[Shader]: https://www.khronos.org/opengl/wiki/Shader
[OpenGL / OpenGL ES Reference Compiler]: https://www.khronos.org/opengles/sdk/tools/Reference-Compiler/
[`std::runtime_error`]: https://en.cppreference.com/w/cpp/error/runtime_error
[`what()`]: https://en.cppreference.com/w/cpp/error/exception/what

## Tests

A test, using [GLFW][], is provided in [`test/`](test/) and can be run with
`make test` from the repository root.

[GLFW]: https://www.glfw.org/

## Dependencies

The [OpenGL Extension Wrangler (GLEW)][] library is used for extension loading.

[`str.hpp`][] is bundled.

Installing dependencies on a Linux distribution using the [APT package
manager][] can be done with:

```sh
// Library dependencies.
sudo apt-get install \
    libgl1-mesa-dev \
    libglew-dev

// Test dependencies.
sudo apt-get install \
    libglfw3-dev
```

[OpenGL Extension Wrangler (GLEW)]: http://glew.sourceforge.net
[`str.hpp`]: https://git.rcrnstn.net/rcrnstn/str.hpp
[APT package manager]: https://en.wikipedia.org/wiki/APT_(software)

## License

Licensed under the [ISC license][], see the [`LICENSE`](LICENSE) file.

[ISC license]: https://en.wikipedia.org/wiki/ISC_license
