#ifndef GLSHADER_SHADER_HPP
#define GLSHADER_SHADER_HPP


#include <vector>
#include <string>

#include <GL/glew.h>


class Shader {
public:

    Shader(std::vector<std::string> paths, std::string name = "");
    Shader(Shader &&);
    Shader(Shader const &);
    Shader & operator=(Shader &&);
    Shader & operator=(Shader const &);
    ~Shader();

    Shader & use();
    Shader & validate();

private:

    void new_();
    void delete_();
    void ensure_current_(
        std::string const & operation,
        std::string const & name = ""
    );

    GLuint program_;
    std::vector<std::string> paths_;
    std::string name_;
};


#ifdef NDEBUG
    #define GLSHADER_ENSURE_CURRENT(OPERATION, NAME)
#else
    #define GLSHADER_ENSURE_CURRENT(OPERATION, NAME) \
        ensure_current_(OPERATION, NAME)
#endif


#endif // GLSHADER_SHADER_HPP
