from setuptools import setup

with open("README.md") as f:
    long_description = f.read()

setup(
    name='glregistry',
    version='1.0.0',
    description="""
        Cache and query the OpenGL registry locally.
    """,
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://git.rcrnstn.net/rcrnstn/glregistry',
    author="Robert Cranston",
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: ISC License (ISCL)',
    ],
    python_requires='>=3, <4',
    install_requires=[
        'docopt',
        'lxml',
    ],
    py_modules=['glregistry'],
    entry_points={
        'console_scripts': [
            'glregistry = glregistry:main',
        ],
    },
)
