# [`glregistry`][]

Cache and query the [OpenGL][] [registry][] locally.

`glregistry` is a Python program that glues together [HTTPS][] downloading,
[XPath][] querying, data accumulation/sorting, [`grep`][]ing, [color][] output,
and launching external [editor][]/[pager][] programs.

It tries to be a good Unix citizen by obeying relevant environment variables
and being [pipe][]-friendly, outputting newline-separated entries. Where
appropriate each line is in a widely supported format, usable with e.g.
[Vim][]'s [QuickFix][] ([`:cexpr`][]` system('glregistry audit')` or [`vim
-q`][]` <(glregistry audit)`) and [GNU Emacs][]' [Compilation Mode][] ([`M-x
compile`][]` glregistry audit`).

Note that only the OpenGL (not OpenGL ES) API, and only the core (not
compatibility) [profile][] is considered.

[`glregistry`]: https://git.rcrnstn.net/rcrnstn/glregistry
[OpenGL]: https://en.wikipedia.org/wiki/OpenGL
[registry]: https://registry.khronos.org/OpenGL/
[HTTPS]: https://en.wikipedia.org/wiki/HTTPS
[XPath]: https://en.wikipedia.org/wiki/XPath
[`grep`]: https://en.wikipedia.org/wiki/Grep
[color]: https://en.wikipedia.org/wiki/ANSI_escape_code#Colors
[editor]: https://en.wikipedia.org/wiki/Text_editor
[pager]: https://en.wikipedia.org/wiki/Terminal_pager
[pipe]: https://en.wikipedia.org/wiki/Pipeline_(Unix)
[Vim]: https://en.wikipedia.org/wiki/Vim_(text_editor)
[QuickFix]: https://vimhelp.org/quickfix.txt.html
[`:cexpr`]: https://vimhelp.org/quickfix.txt.html#%3Acexpr
[`vim -q`]: https://vimhelp.org/starting.txt.html#-q
[GNU Emacs]: https://en.wikipedia.org/wiki/GNU_Emacs
[Compilation Mode]: https://www.gnu.org/software/emacs/manual/html_node/emacs/Compilation-Mode.html
[`M-x compile`]: https://www.gnu.org/software/emacs/manual/html_node/emacs/Compilation.html#index-compile-2624
[profile]: https://www.khronos.org/opengl/wiki/OpenGL_Context#OpenGL_3.2_and_Profiles

## Usage

`glregistry --help`:

```
glregistry 1.0

Cache and query the OpenGL registry locally.

Usage:
  glregistry xml
  glregistry xml-path
  glregistry ext            <extension>
  glregistry ext-path       <extension>
  glregistry exts
  glregistry exts-download
  glregistry exts-all       <name>
  glregistry type           <type>
  glregistry value          <enum>
  glregistry enum           <value>
  glregistry supports       <name>
  glregistry names          [<support>]
  glregistry groups         [<enum>]
  glregistry enums          [<group>]
  glregistry enums-tree     [<group>]
  glregistry params         [<group>]
  glregistry params-tree    [<group>]
  glregistry audit          [<path>]
  glregistry audit-tree     [<path>]
  glregistry refs           <name>
  glregistry refs-all       <name>
  glregistry -h|--help

Commands:
  xml
    Download the registry XML and open it with an editor.
  xml-path
    Download the registry XML and print its local path.
  ext <extension>
    Download the <extension> spec and open it with an editor.
  ext-path <extension>
    Download the <extension> spec and print its local path.
  exts
    Print the names of all extension specs.
  exts-download
    Download all extension specs.
  exts-all <name>
    Print all downloaded extensions that mention <name>.
  type <type>
    Print the definition of <type>.
  value <enum>
    Print the value of <enum>.
  enum <value>
    Print the enum(s) that has the given <value>, using exact string matching.
  supports <name>
    Print the OpenGL version or extension required to use <name>.
  names [<support>]
    Print the names introduced by the OpenGL version or extension <support> if
    given, or all names if omitted. The special values VERSION and EXTENSION
    print the names introduced by all versions or all extensions respectively.
  groups [<enum>]
    Print the groups of <enum> if given, or all groups if omitted.
  enums [<group>]
    Print the enums in <group> if given, or all enums if omitted.
  enums-tree [<group>]
    Print the enums in <group> if given, or all enums if omitted, sorted on
    support, in a tree.
  params [<group>]
    Print the parameter names of <group> if given, or all parameter names if
    omitted.
  params-tree [<group>]
    Print the parameter names of <group> if given, or all parameter names if
    omitted, sorted on count, together with the commands sorted on support, in
    a tree.
  audit [<path>]
    Search files in <path> if given, or the current directory if omitted,
    recursively for OpenGL API names and print them sorted on location,
    support, and name, in a list.
  audit-tree [<path>]
    Search files in <path> if given, or the current directory if omitted,
    recursively for OpenGL API names and print them sorted on support, name,
    and location, in a tree.
  refs <name>
    Print the URLs of all reference pages with name <name>.
  refs-all <name>
    Print the URLs of all reference pages that mention <name>, sorted on
    support, in a tree.

Environment variables:
  GLREGISTRY_CACHE
    The directory to cache files in. Defaults to `$XDG_CACHE_HOME/glregistry`
    or, if `$XDG_CACHE_HOME` is not defined, `$HOME/.cache/glregistry`.
  GLREGISTRY_EDITOR
    The editor to use when opening files. Defaults to `$EDITOR` or, if
    `$EDITOR` is not defined, `editor` if it exists in `$PATH`, else `vi`. The
    value is interpreted by the shell.
  GLREGISTRY_PAGER
    The pager to use when viewing output. Defaults to `$PAGER` or, if `$PAGER`
    is not defined, `pager` if it exists in `$PATH`, else `less` . The value is
    interpreted by the shell. If the `$LESS` environment variable is unset, it
    is set to `FR`.
```

## References

Note that some of these might be out of date.

-   <https://github.com/KhronosGroup/OpenGL-Registry/blob/main/xml/readme.pdf>
-   <https://github.com/KhronosGroup/OpenGL-Registry/blob/main/xml/registry.rnc>
-   <https://github.com/KhronosGroup/OpenGL-Registry/blob/main/xml/reg.py>
-   <https://github.com/KhronosGroup/OpenGL-Registry/blob/main/xml/genheaders.py>
-   <https://github.com/KhronosGroup/OpenGL-Registry/blob/main/extensions/registry.py>
-   <https://github.com/KhronosGroup/OpenGL-Registry/blob/main/docs/syntaxrules.txt>
-   <https://github.com/KhronosGroup/OpenGL-Registry/blob/main/docs/promoting.html>
-   <https://github.com/KhronosGroup/OpenGL-Registry/blob/main/docs/enums.html>
-   <https://github.com/KhronosGroup/OpenGL-Registry/issues/481>

See also:

-   The community-driven [OpenGL Hardware Database][].

[OpenGL Hardware Database]: https://opengl.gpuinfo.org

## Install

Make sure [Python is installed][Python download], [`pip`][] is available and
the [`pip`][], [`setuptools`][] and [`wheel`][] packages are up to date:

```sh
python3 -m pip install --user --upgrade pip setuptools wheel
```

Reference: [Python Packaging User Guide: Requirements for Installing
Packages][].

[Python download]: https://python.org/download
[`pip`]: https://pip.readthedocs.io
[`setuptools`]: https://setuptools.readthedocs.io
[`wheel`]: https://wheel.readthedocs.io
[Python Packaging User Guide: Requirements for Installing Packages]: https://packaging.python.org/tutorials/installing-packages/#requirements-for-installing-packages

### With [`pipx`][], for users

Make sure [`pipx`][] is installed:

```sh
python3 -m pip install --user pipx
```

Install `glregistry`:

```sh
pipx install "git+https://git.rcrnstn.net/rcrnstn/glregistry"
```

`glregistry` should now be in your [`PATH`][] (if not, run `python3 -m pipx
ensurepath`).

Reference: [Python Packaging User Guide: Installing stand alone command line
tools][].

[`pipx`]: https://pipxproject.github.io/pipx/
[`PATH`]: https://en.wikipedia.org/wiki/PATH_(variable)
[Python Packaging User Guide: Installing stand alone command line tools]: https://packaging.python.org/guides/installing-stand-alone-command-line-tools/

### Into [`venv`][], for developers

Clone and install into a repository [`venv`][] virtual environment:

```sh
git clone "https://git.rcrnstn.net/rcrnstn/glregistry"
cd "glregistry"
python3 -m venv .venv
. .venv/bin/activate
python3 -m pip install --editable .
```

`glregistry` should now be in your (virtual environment) [`PATH`][].

Reference: [Python Packaging User Guide: Installing packages using pip and
virtual environments][].

[`venv`]: https://docs.python.org/3/library/venv.html
[Python Packaging User Guide: Installing packages using pip and virtual environments]: https://packaging.python.org/guides/installing-using-pip-and-virtual-environments/

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc/
[`LICENSE`]: LICENSE
