# [`globject`][]

A [C++11][]/[OpenGL][]>=[1.0][] [object][] library.

This library provides a class that is intended to be the base class of several
other classes that encapsulate different types of OpenGL objects, making it
easy to avoid [common mistakes][].

[`globject`]: https://git.rcrnstn.net/rcrnstn/globject
[C++11]: https://en.wikipedia.org/wiki/C++11
[OpenGL]: https://en.wikipedia.org/wiki/OpenGL
[1.0]: https://en.wikipedia.org/wiki/OpenGL#Version_history
[object]: https://www.khronos.org/opengl/wiki/OpenGL_Object
[common mistakes]: https://www.khronos.org/opengl/wiki/Common_Mistakes#The_Object_Oriented_Language_Problem

## Usage

### Template arguments

`GLObject` is template specialized the following values.

-   `GL_TEXTURE`
-   `GL_BUFFER`
-   `GL_QUERY`
-   `GL_PROGRAM`
-   `GL_SHADER`
-   `GL_VERTEX_ARRAY`
-   `GL_FRAMEBUFFER`
-   `GL_RENDERBUFFER`
-   `GL_SAMPLER`
-   `GL_TRANSFORM_FEEDBACK`
-   `GL_PROGRAM_PIPELINE`

The class handles the lifetime of an OpenGL object of the corresponding type.

### Special member functions

All [special member functions][] are `protected`. It is impossible to directly
instantiate `GLObject`s, or to delete objects through `GLObject` pointers.
Instead, use a derived class that encapsulates a specific type of OpenGL
object.

There are no (non-[`delete`][]d) default constructor, copy constructor, or copy
assignment operators. This enforces the invariant that a successfully
constructed instance (that has not been moved from) always (is the only
instance that) corresponds to a valid OpenGL object.

The move constructor/assignment operator's [`noexcept`][] specifiers are only
guaranteed to be honored if [`debug()`][] is `0`.

The constructor takes as arguments:

-   `std::string const & label`. Used when printing debug messages, throwing
    exceptions, and, if OpenGL>=[4.3][] or the [`KHR_debug`][] extension is
    available, passed to [`glObjectLabel`][].

[special member functions]: https://en.wikipedia.org/wiki/Special_member_functions
[`delete`]: https://en.cppreference.com/w/cpp/language/function#Deleted_functions
[`noexcept`]: https://en.cppreference.com/w/cpp/language/noexcept_spec
[`debug()`]: https://git.rcrnstn.net/rcrnstn/glbase/#debug
[4.3]: https://en.wikipedia.org/wiki/OpenGL#Version_history
[`KHR_debug`]: https://registry.khronos.org/OpenGL/extensions/KHR/KHR_debug.txt
[`glObjectLabel`]: https://registry.khronos.org/OpenGL-Refpages/gl4/html/glObjectLabel.xhtml

### Object

`GLuint object() const` returns the underlying OpenGL object. This is
guaranteed to be valid, unless the constructor threw an exception or the
`GLObject` has been moved from, in which case it is `0`.

### Name

`std::string name() const` returns a string representation of the object.

### Debug

`void debug_action_(std::string const & action)` calls outputs a debug message
containing `action` and `name()`.

### Fail

`void fail_action_(std::string const & action) const` throws an exception with
a message containing `action` and `name()`.

## Building

See [`BUILDING.md`][].

[`BUILDING.md`]: BUILDING.md

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc
[`LICENSE`]: LICENSE
