/// Includes


#include "globject.hpp"

#include <algorithm>
#include <cstddef>

#include <glbase.hpp>

#include <str.hpp>


/// Object


std::string GLObject<0>::label_(
    GLenum object_type,
    GLuint object
)
{
    if (!supported({4, 3}, "GL_KHR_debug"))
        return {};
    auto length = GLint{};
    glGetObjectLabel(
        object_type,
        object,
        0,
        &length,
        nullptr
    );
    auto label = std::string((std::size_t)length, char{});
    glGetObjectLabel(
        object_type,
        object,
        length+1,
        nullptr,
        &label[0]
    );
    check_error_(glGetError());
    return label;
}


void GLObject<0>::label_(
    GLenum              object_type,
    GLuint              object,
    std::string const & label
)
{
    if (!supported({4, 3}, "GL_KHR_debug"))
        return;
    auto thread_local label_length_max = integer(GL_MAX_LABEL_LENGTH);
    auto label_length = std::min(
        (GLsizei)label_length_max,
        (GLsizei)label.length()
    );
    glObjectLabel(
        object_type,
        object,
        label_length,
        label.c_str()
    );
}


/// Name


std::string GLObject<0>::name_(
    GLenum              object_type,
    GLuint              object,
    std::string const & label
)
{
    return STR_JOIN(" ", it, it, {
        str_object_type_(object_type),
        object
            ? STR(object)
            : "",
        !label.empty()
            ? label
            : label_(object_type, object),
    });
}
