#include <iostream>
#include <string>
#include <utility>

#include <glm/glm.hpp>

#include <globject.hpp>


class GLObjectTest : public GLObject
{
public:
    explicit GLObjectTest()
    :
        GLObject(
            nullptr,
            nullptr,
            0,
            "GLObjectTest"
        )
    {
        std::cout
            << "glm::mat4x3:"                                                                << "\n"
            << "  name:            "  <<           DataTraits<glm::mat4x3>::name             << "\n"
            << "  columns:         "  <<           DataTraits<glm::mat4x3>::columns          << "\n"
            << "  rows:            "  <<           DataTraits<glm::mat4x3>::rows             << "\n"
            << "  format:          "  << str_enum_(DataTraits<glm::mat4x3>::format)          << "\n"
            << "  type:            "  << str_enum_(DataTraits<glm::mat4x3>::type)            << "\n"
            << "  internal_format: "  << str_enum_(DataTraits<glm::mat4x3>::internal_format) << "\n";

        std::cout
            << path_prefix_("path", "")       << "\n"
            << path_prefix_("path", "prefix") << "\n";

        // NOLINTNEXTLINE
        TGA tga({1, 1}, {0, 0, 255, 127});
        std::cout
            << "TGA:"                                                    << "\n"
            << "  size:      " << tga.size()[0] << ", " << tga.size()[1] << "\n"
            << "  data size: " << tga.data().size()                      << "\n";

        std::cout
            << str_path_  ("path")             << "\n"
            << str_paths_ ({"path1", "path2"}) << "\n"
            << str_enum_  (0x01)               << "\n"
            << str_error_ (GL_NO_ERROR)        << "\n";
    }
};


int main()
{
    std::cout
        << "Supported 1.0: "
        << GLObject::supported({1, 0})
        << "\n";
    std::cout
        << "GL_ACTIVE_TEXTURE: "
        << GLObject::get_integer(GL_ACTIVE_TEXTURE)
        << "\n";
    GLObject::debug_callback()("Debug callback");

    auto const print_debug_objects_info = []()
    {
        std::cout << GLObject::debug_objects_info() << "\n";
    };
    print_debug_objects_info();
    {
        auto object_test_moved = GLObjectTest{};
        auto object_test = std::move(object_test_moved);
        print_debug_objects_info();
    }
    print_debug_objects_info();

    return 0;
}
