#include <GL/glew.h>
template <> struct GLObject::DataTraits<GLfloat> {
  auto static constexpr name = "GLfloat";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{1};
  auto static constexpr format = GLenum{0x1903};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x822E};
  void static attrib(GLuint index, GLfloat const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewVertexAttrib1f(index, value);
  }
  void static uniform(GLint location, GLfloat const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniform1f(location, value);
  }
};
template <> struct GLObject::DataTraits<GLbyte> {
  auto static constexpr name = "GLbyte";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{1};
  auto static constexpr format = GLenum{0x1903};
  auto static constexpr type = GLenum{0x1400};
  auto static constexpr internal_format = GLenum{0x8231};
  void static attrib(GLuint index, GLbyte const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI1i(index, value);
  }
  void static uniform(GLint location, GLbyte const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniform1i(location, value);
  }
};
template <> struct GLObject::DataTraits<GLshort> {
  auto static constexpr name = "GLshort";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{1};
  auto static constexpr format = GLenum{0x1903};
  auto static constexpr type = GLenum{0x1402};
  auto static constexpr internal_format = GLenum{0x8233};
  void static attrib(GLuint index, GLshort const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI1i(index, value);
  }
  void static uniform(GLint location, GLshort const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniform1i(location, value);
  }
};
template <> struct GLObject::DataTraits<GLint> {
  auto static constexpr name = "GLint";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{1};
  auto static constexpr format = GLenum{0x1903};
  auto static constexpr type = GLenum{0x1404};
  auto static constexpr internal_format = GLenum{0x8235};
  void static attrib(GLuint index, GLint const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI1i(index, value);
  }
  void static uniform(GLint location, GLint const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniform1i(location, value);
  }
};
template <> struct GLObject::DataTraits<GLubyte> {
  auto static constexpr name = "GLubyte";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{1};
  auto static constexpr format = GLenum{0x1903};
  auto static constexpr type = GLenum{0x1401};
  auto static constexpr internal_format = GLenum{0x8232};
  void static attrib(GLuint index, GLubyte const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI1ui(index, value);
  }
  void static uniform(GLint location, GLubyte const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewUniform1ui(location, value);
  }
};
template <> struct GLObject::DataTraits<GLushort> {
  auto static constexpr name = "GLushort";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{1};
  auto static constexpr format = GLenum{0x1903};
  auto static constexpr type = GLenum{0x1403};
  auto static constexpr internal_format = GLenum{0x8234};
  void static attrib(GLuint index, GLushort const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI1ui(index, value);
  }
  void static uniform(GLint location, GLushort const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewUniform1ui(location, value);
  }
};
template <> struct GLObject::DataTraits<GLuint> {
  auto static constexpr name = "GLuint";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{1};
  auto static constexpr format = GLenum{0x1903};
  auto static constexpr type = GLenum{0x1405};
  auto static constexpr internal_format = GLenum{0x8236};
  void static attrib(GLuint index, GLuint const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI1ui(index, value);
  }
  void static uniform(GLint location, GLuint const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewUniform1ui(location, value);
  }
};
template <> struct GLObject::DataTraits<glm::vec2> {
  auto static constexpr name = "glm::vec2";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{2};
  auto static constexpr format = GLenum{0x8227};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8230};
  void static attrib(GLuint index, glm::vec2 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewVertexAttrib2fv(index, glm::value_ptr(value));
  }
  void static uniform(GLint location, glm::vec2 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniform2fv(location, 1, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::vec3> {
  auto static constexpr name = "glm::vec3";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{3};
  auto static constexpr format = GLenum{0x1907};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8815};
  void static attrib(GLuint index, glm::vec3 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewVertexAttrib3fv(index, glm::value_ptr(value));
  }
  void static uniform(GLint location, glm::vec3 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniform3fv(location, 1, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::vec4> {
  auto static constexpr name = "glm::vec4";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{4};
  auto static constexpr format = GLenum{0x1908};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8814};
  void static attrib(GLuint index, glm::vec4 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewVertexAttrib4fv(index, glm::value_ptr(value));
  }
  void static uniform(GLint location, glm::vec4 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniform4fv(location, 1, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::ivec2> {
  auto static constexpr name = "glm::ivec2";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{2};
  auto static constexpr format = GLenum{0x8227};
  auto static constexpr type = GLenum{0x1404};
  auto static constexpr internal_format = GLenum{0x823B};
  void static attrib(GLuint index, glm::ivec2 const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI2iv(index, glm::value_ptr(value));
  }
  void static uniform(GLint location, glm::ivec2 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniform2iv(location, 1, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::ivec3> {
  auto static constexpr name = "glm::ivec3";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{3};
  auto static constexpr format = GLenum{0x1907};
  auto static constexpr type = GLenum{0x1404};
  auto static constexpr internal_format = GLenum{0x8D83};
  void static attrib(GLuint index, glm::ivec3 const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI3iv(index, glm::value_ptr(value));
  }
  void static uniform(GLint location, glm::ivec3 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniform3iv(location, 1, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::ivec4> {
  auto static constexpr name = "glm::ivec4";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{4};
  auto static constexpr format = GLenum{0x1908};
  auto static constexpr type = GLenum{0x1404};
  auto static constexpr internal_format = GLenum{0x8D82};
  void static attrib(GLuint index, glm::ivec4 const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI4iv(index, glm::value_ptr(value));
  }
  void static uniform(GLint location, glm::ivec4 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniform4iv(location, 1, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::uvec2> {
  auto static constexpr name = "glm::uvec2";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{2};
  auto static constexpr format = GLenum{0x8227};
  auto static constexpr type = GLenum{0x1405};
  auto static constexpr internal_format = GLenum{0x823C};
  void static attrib(GLuint index, glm::uvec2 const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI2uiv(index, glm::value_ptr(value));
  }
  void static uniform(GLint location, glm::uvec2 const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewUniform2uiv(location, 1, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::uvec3> {
  auto static constexpr name = "glm::uvec3";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{3};
  auto static constexpr format = GLenum{0x1907};
  auto static constexpr type = GLenum{0x1405};
  auto static constexpr internal_format = GLenum{0x8D71};
  void static attrib(GLuint index, glm::uvec3 const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI3uiv(index, glm::value_ptr(value));
  }
  void static uniform(GLint location, glm::uvec3 const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewUniform3uiv(location, 1, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::uvec4> {
  auto static constexpr name = "glm::uvec4";
  auto static constexpr columns = GLint{1};
  auto static constexpr rows = GLint{4};
  auto static constexpr format = GLenum{0x1908};
  auto static constexpr type = GLenum{0x1405};
  auto static constexpr internal_format = GLenum{0x8D70};
  void static attrib(GLuint index, glm::uvec4 const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewVertexAttribI4uiv(index, glm::value_ptr(value));
  }
  void static uniform(GLint location, glm::uvec4 const &value) {
    if (GLObject::debug())
      check_supported_({3, 0});
    __glewUniform4uiv(location, 1, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::mat2> {
  auto static constexpr name = "glm::mat2";
  auto static constexpr columns = GLint{2};
  auto static constexpr rows = GLint{2};
  auto static constexpr format = GLenum{0x8227};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8230};
  void static attrib(GLuint index, glm::mat2 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    for (auto column = GLuint{0}; column < columns; ++column)
      __glewVertexAttrib2fv(index + column,
                            glm::value_ptr(value) + (column * rows));
  }
  void static uniform(GLint location, glm::mat2 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniformMatrix2fv(location, 1, 0, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::mat2x3> {
  auto static constexpr name = "glm::mat2x3";
  auto static constexpr columns = GLint{2};
  auto static constexpr rows = GLint{3};
  auto static constexpr format = GLenum{0x1907};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8815};
  void static attrib(GLuint index, glm::mat2x3 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    for (auto column = GLuint{0}; column < columns; ++column)
      __glewVertexAttrib3fv(index + column,
                            glm::value_ptr(value) + (column * rows));
  }
  void static uniform(GLint location, glm::mat2x3 const &value) {
    if (GLObject::debug())
      check_supported_({2, 1});
    __glewUniformMatrix2x3fv(location, 1, 0, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::mat2x4> {
  auto static constexpr name = "glm::mat2x4";
  auto static constexpr columns = GLint{2};
  auto static constexpr rows = GLint{4};
  auto static constexpr format = GLenum{0x1908};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8814};
  void static attrib(GLuint index, glm::mat2x4 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    for (auto column = GLuint{0}; column < columns; ++column)
      __glewVertexAttrib4fv(index + column,
                            glm::value_ptr(value) + (column * rows));
  }
  void static uniform(GLint location, glm::mat2x4 const &value) {
    if (GLObject::debug())
      check_supported_({2, 1});
    __glewUniformMatrix2x4fv(location, 1, 0, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::mat3x2> {
  auto static constexpr name = "glm::mat3x2";
  auto static constexpr columns = GLint{3};
  auto static constexpr rows = GLint{2};
  auto static constexpr format = GLenum{0x8227};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8230};
  void static attrib(GLuint index, glm::mat3x2 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    for (auto column = GLuint{0}; column < columns; ++column)
      __glewVertexAttrib2fv(index + column,
                            glm::value_ptr(value) + (column * rows));
  }
  void static uniform(GLint location, glm::mat3x2 const &value) {
    if (GLObject::debug())
      check_supported_({2, 1});
    __glewUniformMatrix3x2fv(location, 1, 0, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::mat3> {
  auto static constexpr name = "glm::mat3";
  auto static constexpr columns = GLint{3};
  auto static constexpr rows = GLint{3};
  auto static constexpr format = GLenum{0x1907};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8815};
  void static attrib(GLuint index, glm::mat3 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    for (auto column = GLuint{0}; column < columns; ++column)
      __glewVertexAttrib3fv(index + column,
                            glm::value_ptr(value) + (column * rows));
  }
  void static uniform(GLint location, glm::mat3 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniformMatrix3fv(location, 1, 0, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::mat3x4> {
  auto static constexpr name = "glm::mat3x4";
  auto static constexpr columns = GLint{3};
  auto static constexpr rows = GLint{4};
  auto static constexpr format = GLenum{0x1908};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8814};
  void static attrib(GLuint index, glm::mat3x4 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    for (auto column = GLuint{0}; column < columns; ++column)
      __glewVertexAttrib4fv(index + column,
                            glm::value_ptr(value) + (column * rows));
  }
  void static uniform(GLint location, glm::mat3x4 const &value) {
    if (GLObject::debug())
      check_supported_({2, 1});
    __glewUniformMatrix3x4fv(location, 1, 0, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::mat4x2> {
  auto static constexpr name = "glm::mat4x2";
  auto static constexpr columns = GLint{4};
  auto static constexpr rows = GLint{2};
  auto static constexpr format = GLenum{0x8227};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8230};
  void static attrib(GLuint index, glm::mat4x2 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    for (auto column = GLuint{0}; column < columns; ++column)
      __glewVertexAttrib2fv(index + column,
                            glm::value_ptr(value) + (column * rows));
  }
  void static uniform(GLint location, glm::mat4x2 const &value) {
    if (GLObject::debug())
      check_supported_({2, 1});
    __glewUniformMatrix4x2fv(location, 1, 0, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::mat4x3> {
  auto static constexpr name = "glm::mat4x3";
  auto static constexpr columns = GLint{4};
  auto static constexpr rows = GLint{3};
  auto static constexpr format = GLenum{0x1907};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8815};
  void static attrib(GLuint index, glm::mat4x3 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    for (auto column = GLuint{0}; column < columns; ++column)
      __glewVertexAttrib3fv(index + column,
                            glm::value_ptr(value) + (column * rows));
  }
  void static uniform(GLint location, glm::mat4x3 const &value) {
    if (GLObject::debug())
      check_supported_({2, 1});
    __glewUniformMatrix4x3fv(location, 1, 0, glm::value_ptr(value));
  }
};
template <> struct GLObject::DataTraits<glm::mat4> {
  auto static constexpr name = "glm::mat4";
  auto static constexpr columns = GLint{4};
  auto static constexpr rows = GLint{4};
  auto static constexpr format = GLenum{0x1908};
  auto static constexpr type = GLenum{0x1406};
  auto static constexpr internal_format = GLenum{0x8814};
  void static attrib(GLuint index, glm::mat4 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    for (auto column = GLuint{0}; column < columns; ++column)
      __glewVertexAttrib4fv(index + column,
                            glm::value_ptr(value) + (column * rows));
  }
  void static uniform(GLint location, glm::mat4 const &value) {
    if (GLObject::debug())
      check_supported_({2, 0});
    __glewUniformMatrix4fv(location, 1, 0, glm::value_ptr(value));
  }
};
