from setuptools import setup

with open("README.md") as f:
    long_description = f.read()

setup(
    name='glewcompat',
    version='1.0.0',
    description="""
        Cache and query the OpenGL registry locally.
    """,
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://git.rcrnstn.net/rcrnstn/glewcompat',
    author="Robert Cranston",
    classifiers=[
        'Programming Language :: Python :: 3',
        'License :: OSI Approved :: ISC License (ISCL)',
    ],
    python_requires='>=3, <4',
    install_requires=[
    ],
    py_modules=['glewcompat'],
    entry_points={
        'console_scripts': [
            'glewcompat = glewcompat:main',
        ],
    },
)
