#include <exception>
#include <iostream>
#include <string>
#include <type_traits>

#include <glbase.hpp>


struct GLBaseTest : protected GLBase
{
    explicit GLBaseTest()
    :
        GLBase{}
    {
        std::cout
            << path_prefix_("path", "")       << "\n"
            << path_prefix_("path", "prefix") << std::endl;

        try
        {
            TGA_::read("nonexistent");
        }
        catch (std::exception const & exception)
        {
            std::cout << exception.what() << std::endl;
        }

        // NOLINTNEXTLINE
        TGA_ tga({1, 1}, {0, 0, 255, 127});
        std::cout
            << "TGA:"                                                    << "\n"
            << "  size:      " << tga.size()[0] << ", " << tga.size()[1] << "\n"
            << "  data size: " << tga.data().size()                      << std::endl;

        std::cout
            << str_path_           ("path")             << "\n"
            << str_paths_          ({"path1", "path2"}) << "\n"
            << str_enum_           (0x01)               << "\n"
            << str_error_          (GL_NO_ERROR)        << "\n"
            << str_object_type_    (GL_TEXTURE)         << "\n"
            << str_glsl_           (GL_FLOAT_VEC3)      << "\n"
            << str_format_         (GL_RGBA)            << "\n"
            << str_type_           (GL_FLOAT)           << "\n"
            << str_internal_format_(GL_RGBA32F)         << std::endl;
    }
};


int main()
{
    static_assert(std::is_empty<GLBase>::value, "GLBase must be empty");

    std::cout
        << "Supported 1.0: "
        << GLBase::supported({1, 0})
        << std::endl;
    std::cout
        << "GL_ACTIVE_TEXTURE: "
        << GLBase::integer(GL_ACTIVE_TEXTURE)
        << std::endl;
    GLBase::debug(1);
    GLBase::debug_message("Debug message");

    GLBaseTest{};
}
