#ifdef GLBACKEND_WXWIDGETS


// #include <wx/wx.h>
#include <wx/app.h>
#include <wx/defs.h>
#include <wx/event.h>
#include <wx/frame.h>
#include <wx/window.h>


class App : public wxApp
{
public:
    bool OnInit() override
    {
        // The default close event handler for wxFrame destroys the frame using
        // Destroy().
        // https://docs.wxwidgets.org/3.0/overview_windowdeletion.html#overview_windowdeletion_default
        auto * frame = new wxFrame(nullptr, wxID_ANY, "baseline_wdwidgets");
        if (!frame)
            return false;
        frame->Show(true);
        return true;
    }
    void OnIdle(wxIdleEvent & event)
    {
        (void)event;
        // Apparently, we only trigger LeakSanitizer if we handle a few
        // messages.
        auto static count = 0;
        if (count++ == 3)
            GetTopWindow()->Close();
    }
    wxDECLARE_EVENT_TABLE(); //NOLINT
};


#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wzero-as-null-pointer-constant"
wxBEGIN_EVENT_TABLE(App, wxApp) // NOLINT
    EVT_IDLE(App::OnIdle) // NOLINT
wxEND_EVENT_TABLE() // NOLINT
#pragma GCC diagnostic pop


wxIMPLEMENT_APP(App);


#else
int main() {}
#endif
