#ifndef GLBACKEND_TESTS_COMMON_RUN_HPP_
#define GLBACKEND_TESTS_COMMON_RUN_HPP_


#include <iostream>
#include <string>

#include <glbase.hpp>
#include <glbackend.hpp>

// NOLINTNEXTLINE
#define STR_EXCEPTION GLBase::Exception
#include <str.hpp>



#define GLBACKEND_TESTS_COMMON_RUN(GLBACKEND) \
    run<GLBACKEND>(#GLBACKEND);


constexpr auto size = std::array<int, 2>{640, 480};


template<typename GLBackend>
inline void run(std::string const & name)
{
    GLBackend::prefix("assets/tests");

    auto backend = GLBackend(name, size);

    std::cout << backend.debug_info() << std::endl;

    backend.callback_render([&]()
    {
        glClearColor(1.0F, 0.0F, 0.0F, 0.5F);
        glClear(GL_COLOR_BUFFER_BIT);
        if (!backend.tga_compare(name + ".tga", true))
            STR_THROW("Frame did not match expected frame.");
        backend.running(false);
    });
    backend.run();
}


#endif
