# `git-multihook`

Manage multiple [Git hooks][githooks] with ease.

Git doesn't allow you to use multiple scripts as hooks for a single action out
of the box. `git-multihook` is meant to be placed in the Git [hooks path][]
(which is [`$GIT_DIR`][]`/hooks` by default, but can be changed to a
centralized location with e.g. `git config --global core.hooksPath
'~/.githooks'`) and be the symlink target of (multiple) standard [Git
hooks][githooks] in that directory. When the hook is run it delegates to,
potentially multiple, (executable) scripts in subdirectories with names on the
form `${hook}.d`.

For example, splitting the [`pre-commit.sample`][] that comes bundled with Git
into two scripts would look something like this:

```
.git/hooks
├── git-multihook
├── pre-commit -> git-multihook
└── pre-commit.d
    ├── nonascii
    └── diffcheck
```

Note that hooks have different interfaces (with regards to standard
in/out/error, return values, etc) and `git-multihook` only makes a general best
effort to accomodate these (specifically, it copies standard in to all the
scripts if it is not a terminal, simply lets standard out/error through, and
returns with the first error code that is non-zero).

[githooks]: https://git-scm.com/docs/githooks
[hooks path]: https://git-scm.com/docs/git-config#Documentation/git-config.txt-corehooksPath
[`$GIT_DIR`]: https://www.git-scm.com/docs/git#Documentation/git.txt-codeGITDIRcode
[`pre-commit.sample`]: https://github.com/git/git/blob/master/templates/hooks--pre-commit.sample

## License

Licensed under the [ISC license][], see the [`LICENSE`](LICENSE) file.

[ISC license]: https://en.wikipedia.org/wiki/ISC_license
