# `git-hook-nocommit`

A [Git hook][] that prevents you from committing unintended content.

`git-hook-nocommit` is intended to be used as a [pre-commit][] hook and will
refuse to commit any files with content that matches (case insensitively) the
[extended regex][] `$GIT_HOOK_NOCOMMIT_REGEX` (or `nocommit|nocheckin` if it is
empty) unless `$GIT_HOOK_NOCOMMIT_DISABLE` is non-empty (or `git commit` is run
with the [`-n,--no-verify`][] flag).

[Git hook]: https://git-scm.com/docs/githooks
[pre-commit]: https://git-scm.com/docs/githooks#_pre_commit
[extended regex]: https://en.wikipedia.org/wiki/Regular_expression#POSIX_basic_and_extended
[`-n,--no-verify`]: https://git-scm.com/docs/git-commit#Documentation/git-commit.txt--n

## License

Licensed under the [ISC license][], see the [`LICENSE`](LICENSE) file.

[ISC license]: https://en.wikipedia.org/wiki/ISC_license
