# [`git-gitolite`][]

Manage the counterpart of a local [Git][] repository on a remote [gitolite][]
host.

[`git-gitolite`]: https://git.rcrnstn.net/rcrnstn/git-gitolite
[Git]: https://en.wikipedia.org/wiki/Git
[gitolite]: https://gitolite.com

## Usage

`git-gitolite --help`:

```
git-gitolite 1.0

Manage the counterpart of a local Git repository on a remote gitolite
host.

usage:
  git-gitolite help
  git-gitolite info
  git-gitolite init <license> [<description> [<references>]]
  git-gitolite remote
  git-gitolite head
  git-gitolite publish
  git-gitolite unpublish
  git-gitolite rm
  git-gitolite <command> [<args>...]
  git-gitolite --help|-h
  git-gitolite --version

commands:
  help
    Runs the gitolite 'help' command.
  info
    Runs the gitolite 'info' command.
  init
    Creates and commits, separately, readme and license files.
    A note about the <license> (which should be an SPDX identifier), as
    well as <description> and <references> if given, is inserted into the
    readme. The readme is opened in the editor configured for git
    for review before each commit. This command then (re)sets the remote
    URL, creates the remote repository and pushes.
  remote
    (Re)sets the remote URL.
  head
    Resets the remote HEAD to point to the same ref as the local HEAD,
    making it the default view on a web server.
  publish
    Grants read permissions to 'gitweb', making it viewable through a
    web server.
  unpublish
    Revokes read permissions from 'gitweb', preventing it from being
    viewable through a web server.
  rm
    (Unlocks and) removes the remote repository.
  <command>
    Perform a gitolite command, filling in the host and repository name
    automatically. See `git-gitolite help` for a list of commands.

environment variables:
  GIT_GITOLITE_USER
    The gitolite user under which repositories are found.
    [default: $USER]
  GIT_GITOLITE_HOST
    The host to connect to.
    [default: git.$(dnsdomainname)]
  GIT_GITOLITE_REMOTE
    The git remote used to identify the gitolite server.
    [default: origin]
```

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc/
[`LICENSE`]: LICENSE
