#version 150


#define QUAD_EMIT_VERTEX_(X, Y, Z, LAYER) position = vec3(X, Y, Z); gl_Position = vec4(position, 1); gl_Layer = LAYER; EmitVertex();


layout(triangles) in;
layout(triangle_strip, max_vertices = 4) out;


out vec3 position;


void quad(int layer, int layer_count)
{
    float z = (layer + 0.5) / layer_count * 2 - 1;
    QUAD_EMIT_VERTEX_(-1, -1, z, layer);
    QUAD_EMIT_VERTEX_(-1, +1, z, layer);
    QUAD_EMIT_VERTEX_(+1, -1, z, layer);
    QUAD_EMIT_VERTEX_(+1, +1, z, layer);
    EndPrimitive();
}
