# [`glfbo3d`][]

A [C++11][] test of [OpenGL][] \>=3.2 3D [Framebuffer Objects (FBOs)][].

[`glfbo3d`][] consists of a single test that demonstrates usage of 3D
[Framebuffer Objects (FBOs)][].

[`glfbo3d`]: https://git.rcrnstn.net/rcrnstn/glfbo3d
[C++11]: https://en.wikipedia.org/wiki/C++11
[OpenGL]: https://www.opengl.org
[Framebuffer Objects (FBOs)]: https://www.khronos.org/opengl/wiki/Framebuffer_Object

## Dependencies

Private (tests):

-   [OpenGL][], system (e.g. [`libgl1-mesa-dev`][]).
-   [OpenGL Extension Wrangler (GLEW)][], system (e.g. [`libglew-dev`][]).
-   [OpenGL Mathematics (GLM)][], system (e.g. [`libglm-dev`][]).
-   [`glshader`][], downloaded as part of the CMake configure step.
-   [`gltest`][], downloaded as part of the CMake configure step.

Private (transitive):

-   [GLFW][], system (e.g. [`libglfw3-dev`][]).
-   [`str`][], downloaded as part of the CMake configure step.

[OpenGL Extension Wrangler (GLEW)]: http://glew.sourceforge.net
[OpenGL Mathematics (GLM)]: https://glm.g-truc.net
[GLFW]: https://www.glfw.org
[`libgl1-mesa-dev`]: https://packages.debian.org/search?keywords=libgl1-mesa-dev
[`libglew-dev`]: https://packages.debian.org/search?keywords=libglew-dev
[`libglm-dev`]: https://packages.debian.org/search?keywords=libglm-dev
[`libglfw3-dev`]: https://packages.debian.org/search?keywords=libglfw3-dev
[`glshader`]: https://git.rcrnstn.net/rcrnstn/glshader
[`gltest`]: https://git.rcrnstn.net/rcrnstn/gltest
[`str`]: https://git.rcrnstn.net/rcrnstn/str

## Build system

There are several ways to use this library in a [CMake][]-based project:

-   Use [`FetchContent`][] to download it and import the targets automatically
    as part of the configure step:

    ```cmake
    include(FetchContent)
    FetchContent_Declare(glfbo3d
        GIT_REPOSITORY https://git.rcrnstn.net/rcrnstn/glfbo3d
    )
    FetchContent_MakeAvailable(
        glfbo3d
    )
    ```

-   Bundle it and import the targets with [`add_subdirectory`][].

-   Use [`find_package`][] (requires that the library is [packaged](#packaging)
    or [installed](#installing)).

As usual, use [`target_link_libraries`][] to declare the dependency.

[CMake]: https://cmake.org
[`FetchContent`]: https://cmake.org/cmake/help/latest/module/FetchContent.html
[`add_subdirectory`]: https://cmake.org/cmake/help/latest/command/add_subdirectory.html
[`find_package`]: https://cmake.org/cmake/help/latest/command/find_package.html
[`target_link_libraries`]: https://cmake.org/cmake/help/latest/command/target_link_libraries.html

### Configure and generate

To configure and generate a build tree, use `cmake`:

```sh
cmake -B build
```

[`cmake`]: https://cmake.org/cmake/help/latest/manual/cmake.1.html#generate-a-project-buildsystem

### Build

To build, use [`cmake --build`][]:

```sh
cmake --build build
```

[`cmake --build`]: https://cmake.org/cmake/help/latest/manual/cmake.1.html#build-a-project

### Test

To run tests, use [`ctest`][]:

```sh
(cd build && ctest --verbose)
```

[`ctest`]: https://cmake.org/cmake/help/latest/manual/ctest.1.html

### Package

To package, use [`cpack`][]:

```sh
(cd build && cpack)
```

[`cpack`]: https://cmake.org/cmake/help/latest/manual/cpack.1.html

### Install

To install onto the current system, use [`cmake --install`][]:

```sh
cmake --install build
```

[`cmake --install`]: https://cmake.org/cmake/help/latest/manual/cmake.1.html#install-a-project

## License

Licensed under the [ISC license][] unless otherwise noted, see the
[`LICENSE`](LICENSE) file.

[ISC license]: https://choosealicense.com/licenses/isc/
