websearch()
{
  # See <https://duckduckgo.com/bangs>.
  xdg-open "https://duckduckgo.com/lite/?q=!ducky ${2+site:}$*"
}

webdebian()
{
  xdg-open "https://packages.debian.org/search?searchon=names&section=all&keywords=$*"
}

webubuntu()
{
  xdg-open "https://packages.ubuntu.com/search?searchon=names&section=all&keywords=$*"
}

webcpp()
{
  websearch "https://cppreference.com/w/cpp/" "$@"
}

webc()
{
  websearch "https://cppreference.com/w/c/" "$@"
}

webwin32()
{
  # websearch "https://learn.microsoft.com/en-us/windows/win32/api/" "$@"
  websearch "https://learn.microsoft.com/en-us/windows/" "win32/api" "$@"
}

webman()
{
  # See also <https://wiki.archlinux.org/title/Man_page#Online_man_pages>.

  # See <https://man.archlinux.org/#USAGE>.
  curl -sfL "https://man.archlinux.org/man/$1${2+.$2}.raw" | man -l -
  # curl -sfL "https://man.archlinux.org/man/$1${2+.$2}.txt" | less

  # See <https://manpages.debian.org/>.
  # curl -sfL "https://manpages.debian.org/$1${2+.$2}.gz" | man -l -

  # websearch "https://man7.org/linux/man-pages/" "$1${2+.$2}"
  # xdg-open "https://man.archlinux.org/search?go=Go&q=$1${2+.$2}"
  # xdg-open "https://manpages.debian.org/$1${2+.$2}"
  # xdg-open "https://man.cx/$1${2+($2)}"
  # xdg-open "https://man.he.net/?section=${2-all}&topic=$1"
}
