# https://pubs.opengroup.org/onlinepubs/9699919799/utilities/V3_chap02.html#tag_18_05_03

# NOTE: `PS0` and `PROMPT_COMMAND` are not POSIX but supported by common
# shells.

__prompt_ps1()
{
  __prompt_exit="$?"
  __prompt_time="$(__prompt_time_stop)"
  __prompt_jobs="$(jobs > '/dev/null'; jobs | wc -l)"
  __prompt_color     '\x01%s\x02'
  __prompt_user_host '%s:'
  __prompt_pwd       '%s'
  __prompt_chroot    ' (chroot:%s)'
  __prompt_ranger    ' (ranger:%s)'
  __prompt_venv      ' (venv:%s)'
  __prompt_git       ' (git:%s)'
  __prompt_jobs      ' {%s}' "$__prompt_jobs"
  __prompt_time      ' [%s]' "$__prompt_time"
  __prompt_exit      ' <%s>' 'TSTP' "$__prompt_exit"
  __prompt_end       ' ' '$' '#'
  __prompt_statusline '\x01%s\x02' "$(
    __prompt_shell     '%s:' 'sh'
    __prompt_user_host '%s:'
    __prompt_pwd       '%s'
  )"
  __prompt_intr '^]'
}

__prompt_ps0()
{
  __prompt_intr '^C'
  __prompt_statusline '%s' "$(
    __prompt_shell     '%s:' 'sh'
    __prompt_user_host '%s:'
    __prompt_pwd       '%s'
    __prompt_run       ':%s'
  )"
  __prompt_reset '%s'
  __prompt_time_start
}

__prompt_command()
{
  __prompt_venv_activate
}

PS1='$(__prompt_ps1)'
PS0='$(__prompt_ps0)'
PROMPT_COMMAND='__prompt_command'
