__prompt_time_dir=''
[ -d "$__prompt_time_dir" ] || __prompt_time_dir="${XDG_RUNTIME_DIR:-"/var/run/user/$(id -u)"}"
[ -d "$__prompt_time_dir" ] || __prompt_time_dir="${XDG_CACHE_HOME:-"$HOME/.cache"}"

__prompt_time_file="$__prompt_time_dir/prompt_time/$$"

mkdir -p "$(dirname "$__prompt_time_file")"

__prompt_time_start()
{
  date '+%s' >| "$__prompt_time_file"
}

__prompt_time_stop()
{
  [ -r "$__prompt_time_file" ] || return 0
  __prompt_time="$(("$(date '+%s')" - "$(cat "$__prompt_time_file")"))"
  rm "$__prompt_time_file"
  [ "$__prompt_time" -gt 0 ] || return 0
  __prompt_time_d="$((__prompt_time / (24*60*60)))"
  __prompt_time_h="$((__prompt_time % (24*60*60) / (60*60)))"
  __prompt_time_m="$((__prompt_time              % (60*60) / (60)))"
  __prompt_time_s="$((__prompt_time                        % (60)))"
  __prompt_time_d="$([ "$__prompt_time_d" -eq 0 ] || printf '%02dd' "$__prompt_time_d")"
  __prompt_time_h="$([ "$__prompt_time_h" -eq 0 ] || printf '%02dh' "$__prompt_time_h")"
  __prompt_time_m="$([ "$__prompt_time_m" -eq 0 ] || printf '%02dm' "$__prompt_time_m")"
  __prompt_time_s="$([ "$__prompt_time_s" -eq 0 ] || printf '%02ds' "$__prompt_time_s")"
  printf '%s' \
    "$__prompt_time_d" \
    "$__prompt_time_h" \
    "$__prompt_time_m" \
    "$__prompt_time_s"
}

__prompt_time()
{
  if [ "$2" ]
  then
    printf "$1" "$2"
  fi
}
