# NOTE: `git-sh-prompt` relies on non-POSIX features, but we use it anyway
# since the risk of a user running a Bourne style shell without these
# features as a login shell is low.

# https://github.com/git/git/blob/master/contrib/completion/git-prompt.sh
if [ -r '/usr/lib/git-core/git-sh-prompt' ]
then
  GIT_PS1_SHOWDIRTYSTATE='y'
  GIT_PS1_SHOWSTASHSTATE='y'
  GIT_PS1_SHOWUNTRACKEDFILES='y'
  GIT_PS1_SHOWUPSTREAM='auto verbose'
  # GIT_PS1_SHOWCOLORHINTS='y'
  . '/usr/lib/git-core/git-sh-prompt'
else
  __git_ps1()
  {
    :
  }
fi

__prompt_git()
{
  __git_ps1 "$@"
}
